/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import com.github.benmanes.caffeine.cache.Caffeine;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.ext.web.client.WebClient;
import java.util.Optional;
import org.eclipse.hono.cache.CacheProvider;
import org.eclipse.hono.client.CommandConsumerFactory;
import org.eclipse.hono.client.CredentialsClientFactory;
import org.eclipse.hono.client.DeviceConnectionClientFactory;
import org.eclipse.hono.client.DownstreamSenderFactory;
import org.eclipse.hono.client.GatewayMapper;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.RegistrationClientFactory;
import org.eclipse.hono.client.RequestResponseClientConfigProperties;
import org.eclipse.hono.client.TenantClientFactory;
import org.eclipse.hono.config.ApplicationConfigProperties;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.config.ServerConfig;
import org.eclipse.hono.config.VertxProperties;
import org.eclipse.hono.service.HealthCheckServer;
import org.eclipse.hono.service.VertxBasedHealthCheckServer;
import org.eclipse.hono.service.cache.SpringCacheProvider;
import org.eclipse.hono.service.resourcelimits.PrometheusBasedResourceLimitChecks;
import org.eclipse.hono.service.resourcelimits.PrometheusBasedResourceLimitChecksConfig;
import org.eclipse.hono.service.resourcelimits.ResourceLimitChecks;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

public abstract class AbstractAdapterConfig {
    @Bean
    public Tracer getTracer() {
        return Optional.ofNullable(TracerResolver.resolveTracer()).orElse((Tracer)NoopTracerFactory.create());
    }

    @Bean
    public Vertx vertx() {
        return Vertx.vertx((VertxOptions)this.vertxProperties().configureVertx(new VertxOptions()));
    }

    @Qualifier(value="messaging")
    @ConfigurationProperties(prefix="hono.messaging")
    @Bean
    public ClientConfigProperties downstreamSenderFactoryConfig() {
        ClientConfigProperties config = new ClientConfigProperties();
        this.customizeDownstreamSenderFactoryConfig(config);
        return config;
    }

    protected void customizeDownstreamSenderFactoryConfig(ClientConfigProperties config) {
    }

    @Qualifier(value="messaging")
    @Bean
    @Scope(value="prototype")
    public DownstreamSenderFactory downstreamSenderFactory() {
        return DownstreamSenderFactory.create((HonoConnection)this.downstreamConnection());
    }

    @Qualifier(value="messaging")
    @Bean
    @Scope(value="prototype")
    public HonoConnection downstreamConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.downstreamSenderFactoryConfig());
    }

    @Qualifier(value="registration")
    @ConfigurationProperties(prefix="hono.registration")
    @Bean
    public RequestResponseClientConfigProperties registrationClientFactoryConfig() {
        RequestResponseClientConfigProperties config = new RequestResponseClientConfigProperties();
        this.customizeRegistrationClientFactoryConfig(config);
        return config;
    }

    protected void customizeRegistrationClientFactoryConfig(RequestResponseClientConfigProperties config) {
    }

    @Bean
    @Qualifier(value="registration")
    @Scope(value="prototype")
    public RegistrationClientFactory registrationClientFactory() {
        return RegistrationClientFactory.create((HonoConnection)this.registrationServiceConnection(), (CacheProvider)this.registrationCacheProvider());
    }

    @Bean
    @Qualifier(value="registration")
    @Scope(value="prototype")
    public HonoConnection registrationServiceConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.registrationClientFactoryConfig());
    }

    @Bean
    @Qualifier(value="registration")
    @Scope(value="prototype")
    public CacheProvider registrationCacheProvider() {
        return AbstractAdapterConfig.newCaffeineCache(this.registrationClientFactoryConfig());
    }

    @Qualifier(value="credentials")
    @ConfigurationProperties(prefix="hono.credentials")
    @Bean
    public RequestResponseClientConfigProperties credentialsClientFactoryConfig() {
        RequestResponseClientConfigProperties config = new RequestResponseClientConfigProperties();
        this.customizeCredentialsClientFactoryConfig(config);
        return config;
    }

    protected void customizeCredentialsClientFactoryConfig(RequestResponseClientConfigProperties config) {
    }

    @Bean
    @Qualifier(value="credentials")
    @Scope(value="prototype")
    public CredentialsClientFactory credentialsClientFactory() {
        return CredentialsClientFactory.create((HonoConnection)this.credentialsServiceConnection(), (CacheProvider)this.credentialsCacheProvider());
    }

    @Bean
    @Qualifier(value="credentials")
    @Scope(value="prototype")
    public HonoConnection credentialsServiceConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.credentialsClientFactoryConfig());
    }

    @Bean
    @Qualifier(value="credentials")
    @Scope(value="prototype")
    public CacheProvider credentialsCacheProvider() {
        return AbstractAdapterConfig.newCaffeineCache(this.credentialsClientFactoryConfig());
    }

    @Qualifier(value="tenant")
    @ConfigurationProperties(prefix="hono.tenant")
    @Bean
    public RequestResponseClientConfigProperties tenantServiceClientConfig() {
        RequestResponseClientConfigProperties config = new RequestResponseClientConfigProperties();
        this.customizeTenantClientFactoryConfig(config);
        return config;
    }

    protected void customizeTenantClientFactoryConfig(RequestResponseClientConfigProperties config) {
    }

    @Bean
    @Qualifier(value="tenant")
    @Scope(value="prototype")
    public TenantClientFactory tenantClientFactory() {
        return TenantClientFactory.create((HonoConnection)this.tenantServiceConnection(), (CacheProvider)this.tenantCacheProvider());
    }

    @Bean
    @Qualifier(value="tenant")
    @Scope(value="prototype")
    public HonoConnection tenantServiceConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.tenantServiceClientConfig());
    }

    @Bean
    @Qualifier(value="tenant")
    @Scope(value="prototype")
    public CacheProvider tenantCacheProvider() {
        return AbstractAdapterConfig.newCaffeineCache(this.tenantServiceClientConfig());
    }

    @Bean
    @Qualifier(value="device_con")
    @Scope(value="prototype")
    public DeviceConnectionClientFactory deviceConnectionClientFactory() {
        return DeviceConnectionClientFactory.create((HonoConnection)this.deviceConnectionServiceConnection());
    }

    @Bean
    @Qualifier(value="device_con")
    @Scope(value="prototype")
    public HonoConnection deviceConnectionServiceConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.deviceConnectionServiceClientConfig());
    }

    @Qualifier(value="device_con")
    @ConfigurationProperties(prefix="hono.device-connection")
    @Bean
    public RequestResponseClientConfigProperties deviceConnectionServiceClientConfig() {
        RequestResponseClientConfigProperties config = new RequestResponseClientConfigProperties();
        this.customizeDeviceConnectionClientFactoryConfig(config);
        return config;
    }

    protected void customizeDeviceConnectionClientFactoryConfig(RequestResponseClientConfigProperties config) {
    }

    @Qualifier(value="command")
    @ConfigurationProperties(prefix="hono.command")
    @Bean
    public ClientConfigProperties commandConsumerFactoryConfig() {
        return new ClientConfigProperties();
    }

    @Bean
    @Scope(value="prototype")
    public CommandConsumerFactory commandConsumerFactory() {
        return CommandConsumerFactory.create((HonoConnection)this.commandConsumerConnection(), (GatewayMapper)this.gatewayMapper());
    }

    @Bean
    @Scope(value="prototype")
    public HonoConnection commandConsumerConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.commandConsumerFactoryConfig());
    }

    @Bean
    @Scope(value="prototype")
    public GatewayMapper gatewayMapper() {
        return GatewayMapper.create((RegistrationClientFactory)this.registrationClientFactory(), (DeviceConnectionClientFactory)this.deviceConnectionClientFactory(), (Tracer)this.getTracer());
    }

    @ConfigurationProperties(value="hono.vertx")
    @Bean
    public VertxProperties vertxProperties() {
        return new VertxProperties();
    }

    private static CacheProvider newCaffeineCache(RequestResponseClientConfigProperties config) {
        return AbstractAdapterConfig.newCaffeineCache(config.getResponseCacheMinSize(), config.getResponseCacheMaxSize());
    }

    private static CacheProvider newCaffeineCache(int minCacheSize, long maxCacheSize) {
        if (maxCacheSize <= 0L) {
            return null;
        }
        Caffeine caffeine = Caffeine.newBuilder().initialCapacity(minCacheSize).maximumSize(Math.max((long)minCacheSize, maxCacheSize));
        CaffeineCacheManager manager = new CaffeineCacheManager();
        manager.setAllowNullValues(false);
        manager.setCaffeine(caffeine);
        return new SpringCacheProvider((CacheManager)manager);
    }

    @Bean
    @ConfigurationProperties(prefix="hono.app")
    public ApplicationConfigProperties applicationConfigProperties() {
        return new ApplicationConfigProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hono.health-check")
    public ServerConfig healthCheckConfigProperties() {
        return new ServerConfig();
    }

    @Bean
    public HealthCheckServer healthCheckServer() {
        return new VertxBasedHealthCheckServer(this.vertx(), this.healthCheckConfigProperties());
    }

    @Bean
    @ConfigurationProperties(prefix="hono.resource-limits.prometheus-based")
    @ConditionalOnProperty(name={"hono.resource-limits.prometheus-based.host"})
    public PrometheusBasedResourceLimitChecksConfig resourceLimitChecksConfig() {
        return new PrometheusBasedResourceLimitChecksConfig();
    }

    @Bean
    @ConditionalOnProperty(name={"hono.resource-limits.prometheus-based.host"})
    public ResourceLimitChecks resourceLimitChecks() {
        PrometheusBasedResourceLimitChecksConfig config = this.resourceLimitChecksConfig();
        return new PrometheusBasedResourceLimitChecks(WebClient.create((Vertx)this.vertx()), config, AbstractAdapterConfig.newCaffeineCache(config.getCacheMinSize(), config.getCacheMaxSize()));
    }
}

