/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tenant;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.Objects;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.RequestResponseEndpoint;
import org.eclipse.hono.service.tenant.TenantMessageFilter;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.TenantConstants;
import org.springframework.beans.factory.annotation.Autowired;

public class TenantAmqpEndpoint
extends RequestResponseEndpoint<ServiceConfigProperties> {
    @Autowired
    public TenantAmqpEndpoint(Vertx vertx) {
        super(Objects.requireNonNull(vertx));
    }

    @Override
    public final String getName() {
        return "tenant";
    }

    @Override
    protected final String getEventBusServiceAddress() {
        return "tenant.in";
    }

    @Override
    protected Future<Boolean> isAuthorized(HonoUser clientPrincipal, ResourceIdentifier resource, Message request) {
        Objects.requireNonNull(request);
        String tenantId = MessageHelper.getTenantId((Message)request);
        if (tenantId == null) {
            return Future.succeededFuture((Object)Boolean.TRUE);
        }
        ResourceIdentifier specificTenantAddress = ResourceIdentifier.fromPath((String[])new String[]{resource.getEndpoint(), tenantId});
        return this.getAuthorizationService().isAuthorized(clientPrincipal, specificTenantAddress, request.getSubject());
    }

    @Override
    protected Future<EventBusMessage> filterResponse(HonoUser clientPrincipal, EventBusMessage response) {
        Objects.requireNonNull(clientPrincipal);
        Objects.requireNonNull(response);
        if (response.getTenant() == null || response.getJsonPayload() == null) {
            return Future.succeededFuture((Object)response);
        }
        ResourceIdentifier resourceId = ResourceIdentifier.from((String)"tenant", (String)response.getTenant(), null);
        return this.getAuthorizationService().isAuthorized(clientPrincipal, resourceId, response.getOperation()).map(isAuthorized -> {
            if (isAuthorized.booleanValue()) {
                return response;
            }
            throw new ClientErrorException(403);
        });
    }

    @Override
    protected Future<EventBusMessage> createEventBusRequestMessage(Message requestMessage, ResourceIdentifier targetAddress, HonoUser clientPrincipal) {
        return Future.succeededFuture((Object)EventBusMessage.forOperation((Message)requestMessage).setAppCorrelationId(requestMessage).setCorrelationId(requestMessage).setTenant(requestMessage).setJsonPayload(requestMessage));
    }

    @Override
    protected boolean passesFormalVerification(ResourceIdentifier linkTarget, Message msg) {
        return TenantMessageFilter.verify(linkTarget, msg);
    }

    @Override
    protected final Message getAmqpReply(EventBusMessage message) {
        return TenantConstants.getAmqpReply((String)"tenant", (EventBusMessage)message);
    }

    @Override
    protected boolean isValidReplyToAddress(ResourceIdentifier replyToAddress) {
        if (replyToAddress == null) {
            return false;
        }
        return replyToAddress.getResourcePath().length >= 2;
    }
}

