/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tenant;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.tenant.BaseTenantService;
import org.eclipse.hono.service.tenant.CompleteTenantService;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.TenantConstants;
import org.eclipse.hono.util.TenantResult;

public abstract class CompleteBaseTenantService<T>
extends BaseTenantService<T>
implements CompleteTenantService {
    @Override
    public final Future<EventBusMessage> processRequest(EventBusMessage request) {
        Objects.requireNonNull(request);
        switch (TenantConstants.TenantAction.from((String)request.getOperation())) {
            case add: {
                return this.processAddRequest(request);
            }
            case get: {
                return this.processGetRequest(request);
            }
            case update: {
                return this.processUpdateRequest(request);
            }
            case remove: {
                return this.processRemoveRequest(request);
            }
        }
        return this.processCustomTenantMessage(request);
    }

    private Future<EventBusMessage> processAddRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        JsonObject payload = this.getRequestPayload(request.getJsonPayload());
        if (tenantId == null) {
            this.log.debug("request does not contain mandatory property [{}]", (Object)"tenant_id");
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (this.isValidRequestPayload(payload)) {
            this.log.debug("creating tenant [{}]", (Object)tenantId);
            Future addResult = Future.future();
            this.addNotPresentFieldsWithDefaultValuesForTenant(payload);
            this.add(tenantId, payload, (Handler<AsyncResult<TenantResult<JsonObject>>>)addResult.completer());
            return addResult.map(tr -> request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setCacheDirective(tr.getCacheDirective()));
        }
        this.log.debug("request contains malformed payload");
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    private Future<EventBusMessage> processUpdateRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        JsonObject payload = this.getRequestPayload(request.getJsonPayload());
        if (tenantId == null) {
            this.log.debug("request does not contain mandatory property [{}]", (Object)"tenant_id");
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (this.isValidRequestPayload(payload)) {
            this.log.debug("updating tenant [{}]", (Object)tenantId);
            Future updateResult = Future.future();
            this.addNotPresentFieldsWithDefaultValuesForTenant(payload);
            this.update(tenantId, payload, (Handler<AsyncResult<TenantResult<JsonObject>>>)updateResult.completer());
            return updateResult.map(tr -> request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setCacheDirective(tr.getCacheDirective()));
        }
        this.log.debug("request contains malformed payload");
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    private Future<EventBusMessage> processRemoveRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        if (tenantId == null) {
            this.log.debug("request does not contain mandatory property [{}]", (Object)"tenant_id");
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("deleting tenant [{}]", (Object)tenantId);
        Future removeResult = Future.future();
        this.remove(tenantId, (Handler<AsyncResult<TenantResult<JsonObject>>>)removeResult.completer());
        return removeResult.map(tr -> request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setCacheDirective(tr.getCacheDirective()));
    }

    private boolean isValidRequestPayload(JsonObject payload) {
        return this.hasValidAdapterSpec(payload) && this.hasValidTrustedCaSpec(payload);
    }

    private boolean hasValidAdapterSpec(JsonObject payload) {
        Object adaptersObj = payload.getValue("adapters");
        if (adaptersObj instanceof JsonArray) {
            JsonArray adapters = (JsonArray)adaptersObj;
            if (adapters.size() == 0) {
                return false;
            }
            boolean containsInvalidAdapter = adapters.stream().anyMatch(obj -> !(obj instanceof JsonObject) || !((JsonObject)obj).containsKey("type"));
            if (containsInvalidAdapter) {
                return false;
            }
        } else if (adaptersObj != null) {
            return false;
        }
        return true;
    }

    private boolean isValidTrustedCaSpec(JsonObject trustedCa) {
        Object encodedCert = trustedCa.getValue("cert");
        Object encodedKey = trustedCa.getValue("public-key");
        Object subjectDn = trustedCa.getValue("subject-dn");
        if (!String.class.isInstance(subjectDn)) {
            return false;
        }
        if (encodedCert != null && encodedKey == null) {
            return this.isEncodedCertificate(encodedCert);
        }
        if (encodedKey != null && encodedCert == null) {
            String algorithmName = Optional.ofNullable((String)trustedCa.getValue("type")).orElse("RSA");
            return this.isEncodedPublicKey(encodedKey, algorithmName);
        }
        return false;
    }

    private boolean isEncodedCertificate(Object encodedCert) {
        if (String.class.isInstance(encodedCert)) {
            try {
                CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode((String)encodedCert)));
                return true;
            }
            catch (IllegalArgumentException | CertificateException e) {
                return false;
            }
        }
        return false;
    }

    private boolean isEncodedPublicKey(Object encodedKey, String algorithmName) {
        if (String.class.isInstance(encodedKey)) {
            try {
                KeyFactory.getInstance(algorithmName).generatePublic(new X509EncodedKeySpec(Base64.getDecoder().decode((String)encodedKey)));
                return true;
            }
            catch (IllegalArgumentException | GeneralSecurityException e) {
                return false;
            }
        }
        return false;
    }

    private boolean hasValidTrustedCaSpec(JsonObject payload) {
        Object trustConfig = payload.getValue("trusted-ca");
        if (trustConfig == null) {
            return true;
        }
        if (JsonObject.class.isInstance(trustConfig)) {
            return this.isValidTrustedCaSpec((JsonObject)trustConfig);
        }
        return false;
    }

    protected final void addNotPresentFieldsWithDefaultValuesForTenant(JsonObject checkedPayload) {
        JsonArray adapters;
        if (!checkedPayload.containsKey("enabled")) {
            this.log.trace("adding 'enabled' key to payload");
            checkedPayload.put("enabled", Boolean.TRUE);
        }
        if ((adapters = checkedPayload.getJsonArray("adapters")) != null) {
            adapters.forEach(elem -> this.addNotPresentFieldsWithDefaultValuesForAdapter((JsonObject)elem));
        }
    }

    private void addNotPresentFieldsWithDefaultValuesForAdapter(JsonObject adapter) {
        if (!adapter.containsKey("enabled")) {
            this.log.trace("adding 'enabled' key to payload");
            adapter.put("enabled", Boolean.TRUE);
        }
        if (!adapter.containsKey("device-authentication-required")) {
            this.log.trace("adding 'device-authentication-required' key to adapter payload");
            adapter.put("device-authentication-required", Boolean.TRUE);
        }
    }

    @Override
    public void add(String tenantId, JsonObject tenantObj, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void update(String tenantId, JsonObject tenantObj, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void remove(String tenantId, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }
}

