/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.util.BaseMessageFilter;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.RegistrationConstants;
import org.eclipse.hono.util.ResourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistrationMessageFilter
extends BaseMessageFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RegistrationMessageFilter.class);

    private RegistrationMessageFilter() {
    }

    public static boolean verify(ResourceIdentifier linkTarget, Message msg) {
        if (!RegistrationMessageFilter.hasValidDeviceId((ResourceIdentifier)linkTarget, (Message)msg)) {
            return false;
        }
        if (!RegistrationMessageFilter.hasCorrelationId((Message)msg)) {
            return false;
        }
        if (!RegistrationConstants.isValidAction((String)msg.getSubject())) {
            LOG.trace("message [{}] does not contain valid action property", msg.getMessageId());
            return false;
        }
        if (msg.getReplyTo() == null) {
            LOG.trace("message [{}] contains no reply-to address", msg.getMessageId());
            return false;
        }
        if (msg.getBody() != null && !MessageHelper.hasDataBody((Message)msg)) {
            LOG.trace("message [{}] contains no Data section payload", msg.getMessageId());
            return false;
        }
        return true;
    }
}

