/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.vertx.core.Vertx;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import org.eclipse.hono.config.SignatureSupportingConfigProperties;
import org.eclipse.hono.service.registration.RegistrationAssertionHelper;
import org.eclipse.hono.util.JwtHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistrationAssertionHelperImpl
extends JwtHelper
implements RegistrationAssertionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RegistrationAssertionHelperImpl.class);

    private RegistrationAssertionHelperImpl() {
        this(null);
    }

    private RegistrationAssertionHelperImpl(Vertx vertx) {
        super(vertx);
    }

    public static RegistrationAssertionHelper forSigning(Vertx vertx, SignatureSupportingConfigProperties config) {
        return (RegistrationAssertionHelper)JwtHelper.forSigning((SignatureSupportingConfigProperties)config, () -> new RegistrationAssertionHelperImpl(vertx));
    }

    public static RegistrationAssertionHelper forValidating(Vertx vertx, SignatureSupportingConfigProperties config) {
        return (RegistrationAssertionHelper)JwtHelper.forValidating((SignatureSupportingConfigProperties)config, () -> new RegistrationAssertionHelperImpl(vertx));
    }

    public static RegistrationAssertionHelper forSharedSecret(String sharedSecret, long tokenExpiration) {
        return (RegistrationAssertionHelper)JwtHelper.forSharedSecret((String)sharedSecret, (long)tokenExpiration, RegistrationAssertionHelperImpl::new);
    }

    @Override
    public String getAssertion(String tenantId, String deviceId) {
        if (this.algorithm == null) {
            throw new IllegalStateException("no algorithm set");
        }
        return Jwts.builder().signWith(this.key, this.algorithm).setSubject(deviceId).claim("ten", (Object)tenantId).setExpiration(Date.from(Instant.now().plus(this.tokenLifetime))).compact();
    }

    @Override
    public boolean isValid(String token, String tenantId, String deviceId) {
        try {
            Jwts.parser().setSigningKey(this.key).requireSubject(Objects.requireNonNull(deviceId)).require("ten", (Object)Objects.requireNonNull(tenantId)).setAllowedClockSkewSeconds(10L).parse(token);
            return true;
        }
        catch (JwtException e) {
            LOG.debug("failed to validate token", (Throwable)e);
            return false;
        }
    }

    @Override
    public long getAssertionLifetime() {
        return this.getTokenLifetime().getSeconds();
    }
}

