/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopSpan;
import io.opentracing.tag.Tags;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.registration.RegistrationAssertionHelper;
import org.eclipse.hono.service.registration.RegistrationService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.RegistrationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class BaseRegistrationService<T>
extends EventBusService<T>
implements RegistrationService {
    private static final String SPAN_NAME_ASSERT_DEVICE_REGISTRATION = "assert Device Registration";
    private RegistrationAssertionHelper assertionFactory;

    @Autowired
    @Qualifier(value="signing")
    public final void setRegistrationAssertionFactory(RegistrationAssertionHelper assertionFactory) {
        this.assertionFactory = Objects.requireNonNull(assertionFactory);
    }

    @Override
    protected void doStart(Future<Void> startFuture) {
        if (this.assertionFactory == null) {
            startFuture.fail((Throwable)new IllegalStateException("registration assertion factory must be set"));
        } else {
            startFuture.complete();
        }
    }

    @Override
    protected String getEventBusAddress() {
        return "registration.in";
    }

    @Override
    public Future<EventBusMessage> processRequest(EventBusMessage requestMessage) {
        Objects.requireNonNull(requestMessage);
        switch (requestMessage.getOperation()) {
            case "assert": {
                return this.processAssertRequest(requestMessage);
            }
        }
        return this.processCustomRegistrationMessage(requestMessage);
    }

    private Future<EventBusMessage> processAssertRequest(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        String gatewayId = request.getGatewayId();
        SpanContext spanContext = request.getSpanContext();
        Span span = this.newChildSpan(SPAN_NAME_ASSERT_DEVICE_REGISTRATION, spanContext, tenantId, deviceId, gatewayId);
        if (tenantId == null || deviceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant and/or device");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            Future result = Future.future();
            if (gatewayId == null) {
                this.log.debug("asserting registration of device [{}] with tenant [{}]", (Object)deviceId, (Object)tenantId);
                this.assertRegistration(tenantId, deviceId, span, (Handler<AsyncResult<RegistrationResult>>)result.completer());
            } else {
                this.log.debug("asserting registration of device [{}] with tenant [{}] for gateway [{}]", new Object[]{deviceId, tenantId, gatewayId});
                this.assertRegistration(tenantId, deviceId, gatewayId, span, (Handler<AsyncResult<RegistrationResult>>)result.completer());
            }
            resultFuture = result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    protected Future<EventBusMessage> processCustomRegistrationMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    public void getDevice(String tenantId, String deviceId, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public final void assertRegistration(String tenantId, String deviceId, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        this.assertRegistration(tenantId, deviceId, (Span)NoopSpan.INSTANCE, resultHandler);
    }

    @Override
    public void assertRegistration(String tenantId, String deviceId, Span span, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(span);
        Objects.requireNonNull(resultHandler);
        Future getResultTracker = Future.future();
        this.getDevice(tenantId, deviceId, (Handler<AsyncResult<RegistrationResult>>)getResultTracker.completer());
        getResultTracker.compose(result -> {
            if (this.isDeviceEnabled((RegistrationResult)result)) {
                JsonObject deviceData = ((JsonObject)result.getPayload()).getJsonObject("data");
                return this.updateDeviceLastViaIfNeeded(tenantId, deviceId, deviceId, deviceData, span).map(res -> this.createSuccessfulRegistrationResult(tenantId, deviceId, deviceData)).recover(t -> Future.succeededFuture((Object)RegistrationResult.from((int)ServiceInvocationException.extractStatusCode((Throwable)t))));
            }
            TracingHelper.logError((Span)span, (String)"device not enabled");
            return Future.succeededFuture((Object)RegistrationResult.from((int)404));
        }).setHandler(resultHandler);
    }

    @Override
    public final void assertRegistration(String tenantId, String deviceId, String gatewayId, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        this.assertRegistration(tenantId, deviceId, gatewayId, (Span)NoopSpan.INSTANCE, resultHandler);
    }

    @Override
    public void assertRegistration(String tenantId, String deviceId, String gatewayId, Span span, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(gatewayId);
        Objects.requireNonNull(span);
        Objects.requireNonNull(resultHandler);
        Future deviceInfoTracker = Future.future();
        Future gatewayInfoTracker = Future.future();
        this.getDevice(tenantId, deviceId, (Handler<AsyncResult<RegistrationResult>>)deviceInfoTracker.completer());
        this.getDevice(tenantId, gatewayId, (Handler<AsyncResult<RegistrationResult>>)gatewayInfoTracker.completer());
        CompositeFuture.all((Future)deviceInfoTracker, (Future)gatewayInfoTracker).compose(ok -> {
            RegistrationResult deviceResult = (RegistrationResult)deviceInfoTracker.result();
            RegistrationResult gatewayResult = (RegistrationResult)gatewayInfoTracker.result();
            if (!this.isDeviceEnabled(deviceResult)) {
                TracingHelper.logError((Span)span, (String)"device not enabled");
                return Future.succeededFuture((Object)RegistrationResult.from((int)404));
            }
            if (!this.isDeviceEnabled(gatewayResult)) {
                TracingHelper.logError((Span)span, (String)"gateway not enabled");
                return Future.succeededFuture((Object)RegistrationResult.from((int)403));
            }
            JsonObject deviceData = ((JsonObject)deviceResult.getPayload()).getJsonObject("data", new JsonObject());
            JsonObject gatewayData = ((JsonObject)gatewayResult.getPayload()).getJsonObject("data", new JsonObject());
            if (this.isGatewayAuthorized(gatewayId, gatewayData, deviceId, deviceData)) {
                return this.updateDeviceLastViaIfNeeded(tenantId, deviceId, gatewayId, deviceData, span).map(res -> this.createSuccessfulRegistrationResult(tenantId, deviceId, deviceData)).recover(t -> Future.succeededFuture((Object)RegistrationResult.from((int)ServiceInvocationException.extractStatusCode((Throwable)t))));
            }
            TracingHelper.logError((Span)span, (String)"gateway not authorized");
            return Future.succeededFuture((Object)RegistrationResult.from((int)403));
        }).setHandler(resultHandler);
    }

    private RegistrationResult createSuccessfulRegistrationResult(String tenantId, String deviceId, JsonObject deviceData) {
        CacheDirective cacheDirective = this.isDeviceWithOneOrMoreVias(deviceData) ? CacheDirective.noCacheDirective() : CacheDirective.maxAgeDirective((long)this.assertionFactory.getAssertionLifetime());
        return RegistrationResult.from((int)200, (JsonObject)this.getAssertionPayload(tenantId, deviceId, deviceData), (CacheDirective)cacheDirective);
    }

    private Future<Void> updateDeviceLastViaIfNeeded(String tenantId, String deviceId, String gatewayId, JsonObject deviceData, Span span) {
        if (!this.isDeviceWithOneOrMoreVias(deviceData)) {
            return Future.succeededFuture();
        }
        return this.updateDeviceLastVia(tenantId, deviceId, gatewayId, deviceData).recover(t -> {
            this.log.error("update of the 'last-via' property failed", t);
            TracingHelper.logError((Span)span, (String)("update of the 'last-via' property failed: " + t.toString()));
            return Future.failedFuture((Throwable)t);
        });
    }

    private boolean isDeviceWithOneOrMoreVias(JsonObject deviceData) {
        Object viaObj = deviceData.getValue("via");
        return viaObj instanceof String && !((String)viaObj).isEmpty() || viaObj instanceof JsonArray && !((JsonArray)viaObj).isEmpty();
    }

    protected abstract Future<Void> updateDeviceLastVia(String var1, String var2, String var3, JsonObject var4);

    protected final Span newChildSpan(String operationName, SpanContext spanContext, String tenantId, String deviceId, String gatewayId) {
        Objects.requireNonNull(operationName);
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(operationName).addReference("child_of", spanContext).ignoreActiveSpan().withTag(Tags.COMPONENT.getKey(), this.getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "server");
        if (tenantId != null) {
            spanBuilder.withTag("tenant_id", tenantId);
        }
        if (deviceId != null) {
            spanBuilder.withTag("device_id", deviceId);
        }
        if (gatewayId != null) {
            spanBuilder.withTag("gateway_id", gatewayId);
        }
        return spanBuilder.start();
    }

    protected void handleUnimplementedOperation(Handler<AsyncResult<RegistrationResult>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)RegistrationResult.from((int)501)));
    }

    protected boolean isGatewayAuthorized(String gatewayId, JsonObject gatewayData, String deviceId, JsonObject deviceData) {
        Objects.requireNonNull(gatewayId);
        Objects.requireNonNull(gatewayData);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(deviceData);
        Object obj = deviceData.getValue("via");
        if (obj instanceof String) {
            return gatewayId.equals(obj);
        }
        if (obj instanceof JsonArray) {
            return ((JsonArray)obj).stream().filter(o -> o instanceof String).anyMatch(id -> gatewayId.equals(id));
        }
        return false;
    }

    private boolean isDeviceEnabled(RegistrationResult registrationResult) {
        return registrationResult.isOk() && this.isDeviceEnabled(((JsonObject)registrationResult.getPayload()).getJsonObject("data"));
    }

    private boolean isDeviceEnabled(JsonObject registrationData) {
        return registrationData.getBoolean("enabled", Boolean.TRUE);
    }

    protected final JsonObject getAssertionPayload(String tenantId, String deviceId, JsonObject registrationInfo) {
        JsonObject result = new JsonObject().put("device-id", deviceId).put("assertion", this.assertionFactory.getAssertion(tenantId, deviceId));
        JsonObject defaults = registrationInfo.getJsonObject("defaults");
        if (defaults != null) {
            result.put("defaults", defaults);
        }
        return result;
    }

    protected static final JsonObject getResultPayload(String deviceId, JsonObject data) {
        return new JsonObject().put("device-id", deviceId).put("data", data);
    }
}

