/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.plan;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.predicate.ResponsePredicate;
import io.vertx.ext.web.codec.BodyCodec;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.eclipse.hono.service.plan.ResourceLimitChecks;
import org.eclipse.hono.util.PortConfigurationHelper;
import org.eclipse.hono.util.TenantObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrometheusBasedResourceLimitChecks
implements ResourceLimitChecks {
    private static final String CONNECTIONS_METRIC_NAME = "hono.connections.authenticated".replace(".", "_");
    private static final Logger log = LoggerFactory.getLogger(PrometheusBasedResourceLimitChecks.class);
    private final WebClient client;
    private String host;
    private int port = 9090;
    private String queryUrl;

    public PrometheusBasedResourceLimitChecks(Vertx vertx) {
        this.client = WebClient.create((Vertx)Objects.requireNonNull(vertx));
    }

    @Override
    public Future<Boolean> isConnectionLimitReached(TenantObject tenant) {
        Objects.requireNonNull(tenant);
        log.trace("connection limit for tenant [{}] is [{}]", (Object)tenant.getTenantId(), (Object)tenant.getConnectionsLimit());
        if (tenant.getConnectionsLimit() == -1L) {
            return Future.succeededFuture((Object)Boolean.FALSE);
        }
        String queryParams = String.format("sum(%s{tenant=\"%s\"})", CONNECTIONS_METRIC_NAME, tenant.getTenantId());
        return this.executeQuery(queryParams).map(currentConnections -> {
            if (currentConnections < tenant.getConnectionsLimit()) {
                return Boolean.FALSE;
            }
            log.trace("connection limit exceeded [tenant: {}, current connections: {}, max-connections: {}]", new Object[]{tenant.getTenantId(), currentConnections, tenant.getConnectionsLimit()});
            return Boolean.TRUE;
        }).otherwise((Object)Boolean.FALSE);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = Objects.requireNonNull(host);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (!PortConfigurationHelper.isValidPort((int)port)) {
            throw new IllegalArgumentException("invalid port number");
        }
        this.port = port;
    }

    @PostConstruct
    private void init() {
        this.queryUrl = String.format("http://%s:%s/api/v1/query", this.getHost(), this.getPort());
    }

    private Future<Long> executeQuery(String query) {
        Future result = Future.future();
        log.trace("running query [{}] against Prometheus backend [{}]", (Object)query, (Object)this.queryUrl);
        this.client.getAbs(this.queryUrl).addQueryParam("query", query).expect(ResponsePredicate.SC_OK).as(BodyCodec.jsonObject()).send(sendAttempt -> {
            if (sendAttempt.succeeded()) {
                HttpResponse response = (HttpResponse)sendAttempt.result();
                result.complete((Object)this.extractLongValue((JsonObject)response.body()));
            } else {
                log.debug("error fetching result from Prometheus [url: {}, query: {}]: {}", new Object[]{this.queryUrl, query, sendAttempt.cause().getMessage()});
                result.fail(sendAttempt.cause());
            }
        });
        return result;
    }

    private Long extractLongValue(JsonObject response) {
        Objects.requireNonNull(response);
        try {
            String value;
            JsonArray valueArray;
            String status = response.getString("status");
            if ("error".equals(status)) {
                log.debug("error while executing query [status: {}, error type: {}, error: {}]", new Object[]{status, response.getString("errorType"), response.getString("error")});
                return 0L;
            }
            JsonObject data = response.getJsonObject("data", new JsonObject());
            JsonArray result = data.getJsonArray("result");
            if (result != null && result.size() == 1 && result.getJsonObject(0) != null && (valueArray = result.getJsonObject(0).getJsonArray("value")) != null && valueArray.size() == 2 && (value = valueArray.getString(1)) != null && !value.isEmpty()) {
                return Long.parseLong(value);
            }
            log.debug("received malformed response from Prometheus server: {}", (Object)response.encodePrettily());
        }
        catch (Exception e) {
            log.debug("received malformed response from Prometheus server: {}", (Object)response.encodePrettily(), (Object)e);
        }
        return 0L;
    }
}

