/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.metric;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Objects;
import org.eclipse.hono.service.metric.LegacyMetrics;
import org.eclipse.hono.service.metric.MetricsTags;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"hono.metrics.legacy"}, havingValue="true")
public final class MicrometerBasedLegacyMetrics
implements LegacyMetrics {
    public static final String METER_MESSAGES_PROCESSED = "hono.messages.processed";
    static final String METER_COMMANDS_DEVICE_DELIVERED = "hono.commands.device.delivered";
    static final String METER_COMMANDS_TTD_EXPIRED = "hono.commands.ttd.expired";
    static final String METER_COMMANDS_RESPONSE_DELIVERED = "hono.commands.response.delivered";
    static final String METER_MESSAGES_UNDELIVERABLE = "hono.messages.undeliverable";
    private final MeterRegistry registry;

    public MicrometerBasedLegacyMetrics(MeterRegistry registry) {
        this.registry = Objects.requireNonNull(registry);
    }

    @Override
    public void incrementProcessedMessages(MetricsTags.EndpointType type, String tenantId) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(tenantId);
        this.registry.counter(METER_MESSAGES_PROCESSED, (Iterable)Tags.of((String)"tenant", (String)tenantId).and(new Tag[]{type.asTag()})).increment();
    }

    @Override
    public void incrementUndeliverableMessages(MetricsTags.EndpointType type, String tenantId) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(tenantId);
        this.registry.counter(METER_MESSAGES_UNDELIVERABLE, (Iterable)Tags.of((String)"tenant", (String)tenantId).and(new Tag[]{type.asTag()})).increment();
    }

    @Override
    public void incrementNoCommandReceivedAndTTDExpired(String tenantId) {
        Objects.requireNonNull(tenantId);
        this.registry.counter(METER_COMMANDS_TTD_EXPIRED, (Iterable)Tags.of((String)"tenant", (String)tenantId)).increment();
    }

    @Override
    public void incrementCommandResponseDeliveredToApplication(String tenantId) {
        Objects.requireNonNull(tenantId);
        this.registry.counter(METER_COMMANDS_RESPONSE_DELIVERED, (Iterable)Tags.of((Tag[])new Tag[]{MetricsTags.getTenantTag(tenantId)})).increment();
    }

    @Override
    public void incrementCommandDeliveredToDevice(String tenantId) {
        Objects.requireNonNull(tenantId);
        this.registry.counter(METER_COMMANDS_DEVICE_DELIVERED, (Iterable)Tags.of((Tag[])new Tag[]{MetricsTags.getTenantTag(tenantId)})).increment();
    }
}

