/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.micrometer.core.instrument.Timer;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.TrustOptions;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonHelper;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.CommandConsumerFactory;
import org.eclipse.hono.client.CommandContext;
import org.eclipse.hono.client.CommandResponse;
import org.eclipse.hono.client.CommandResponseSender;
import org.eclipse.hono.client.ConnectionLifecycle;
import org.eclipse.hono.client.CredentialsClientFactory;
import org.eclipse.hono.client.DisconnectListener;
import org.eclipse.hono.client.DownstreamSender;
import org.eclipse.hono.client.DownstreamSenderFactory;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.MessageConsumer;
import org.eclipse.hono.client.ReconnectListener;
import org.eclipse.hono.client.RegistrationClient;
import org.eclipse.hono.client.RegistrationClientFactory;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.TenantClient;
import org.eclipse.hono.client.TenantClientFactory;
import org.eclipse.hono.config.ProtocolAdapterProperties;
import org.eclipse.hono.service.AbstractServiceBase;
import org.eclipse.hono.service.auth.ValidityBasedTrustOptions;
import org.eclipse.hono.service.limiting.ConnectionLimitManager;
import org.eclipse.hono.service.monitoring.ConnectionEventProducer;
import org.eclipse.hono.service.plan.NoopResourceLimitChecks;
import org.eclipse.hono.service.plan.ResourceLimitChecks;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.Strings;
import org.eclipse.hono.util.TenantObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractProtocolAdapterBase<T extends ProtocolAdapterProperties>
extends AbstractServiceBase<T> {
    protected static final String CONTENT_TYPE_OCTET_STREAM = "application/octet-stream";
    protected static final String KEY_MICROMETER_SAMPLE = "micrometer.sample";
    private DownstreamSenderFactory downstreamSenderFactory;
    private RegistrationClientFactory registrationClientFactory;
    private TenantClientFactory tenantClientFactory;
    private CredentialsClientFactory credentialsClientFactory;
    private CommandConsumerFactory commandConsumerFactory;
    private ConnectionLimitManager connectionLimitManager;
    private ConnectionEventProducer connectionEventProducer;
    private ResourceLimitChecks resourceLimitChecks = new NoopResourceLimitChecks();
    private final ConnectionEventProducer.Context connectionEventProducerContext = new ConnectionEventProducer.Context(){

        @Override
        public DownstreamSenderFactory getMessageSenderClient() {
            return AbstractProtocolAdapterBase.this.downstreamSenderFactory;
        }
    };

    protected static final void addMicrometerSample(CommandContext ctx, Timer.Sample sample) {
        Objects.requireNonNull(ctx);
        ctx.put(KEY_MICROMETER_SAMPLE, (Object)sample);
    }

    protected static final Timer.Sample getMicrometerSample(CommandContext ctx) {
        Objects.requireNonNull(ctx);
        return (Timer.Sample)ctx.get(KEY_MICROMETER_SAMPLE);
    }

    @Autowired
    public void setConfig(T configuration) {
        this.setSpecificConfig(configuration);
    }

    @Qualifier(value="tenant")
    @Autowired
    public final void setTenantClientFactory(TenantClientFactory factory) {
        this.tenantClientFactory = Objects.requireNonNull(factory);
    }

    public final TenantClientFactory getTenantClientFactory() {
        return this.tenantClientFactory;
    }

    protected final Future<TenantClient> getTenantClient() {
        return this.getTenantClientFactory().getOrCreateTenantClient();
    }

    @Qualifier(value="messaging")
    @Autowired
    public final void setDownstreamSenderFactory(DownstreamSenderFactory factory) {
        this.downstreamSenderFactory = Objects.requireNonNull(factory);
    }

    public final DownstreamSenderFactory getDownstreamSenderFactory() {
        return this.downstreamSenderFactory;
    }

    @Qualifier(value="registration")
    @Autowired
    public final void setRegistrationClientFactory(RegistrationClientFactory factory) {
        this.registrationClientFactory = Objects.requireNonNull(factory);
    }

    public final RegistrationClientFactory getRegistrationClientFactory() {
        return this.registrationClientFactory;
    }

    @Qualifier(value="credentials")
    @Autowired
    public final void setCredentialsClientFactory(CredentialsClientFactory factory) {
        this.credentialsClientFactory = Objects.requireNonNull(factory);
    }

    public final CredentialsClientFactory getCredentialsClientFactory() {
        return this.credentialsClientFactory;
    }

    @Autowired(required=false)
    public void setConnectionEventProducer(ConnectionEventProducer connectionEventProducer) {
        this.connectionEventProducer = connectionEventProducer;
    }

    public ConnectionEventProducer getConnectionEventProducer() {
        return this.connectionEventProducer;
    }

    protected abstract String getTypeName();

    protected Future<Integer> getTimeUntilDisconnect(TenantObject tenant, Integer deviceTtd) {
        Objects.requireNonNull(tenant);
        if (deviceTtd == null) {
            return Future.succeededFuture();
        }
        return Future.succeededFuture((Object)Math.min(tenant.getMaxTimeUntilDisconnect(this.getTypeName()), deviceTtd));
    }

    @Autowired
    public final void setCommandConsumerFactory(CommandConsumerFactory factory) {
        this.commandConsumerFactory = Objects.requireNonNull(factory);
    }

    public final CommandConsumerFactory getCommandConsumerFactory() {
        return this.commandConsumerFactory;
    }

    @Autowired(required=false)
    public final void setResourceLimitChecks(ResourceLimitChecks resourceLimitChecks) {
        this.resourceLimitChecks = Objects.requireNonNull(resourceLimitChecks);
    }

    protected final ResourceLimitChecks getResourceLimitChecks() {
        return this.resourceLimitChecks;
    }

    @Override
    protected final Future<Void> startInternal() {
        Future result = Future.future();
        if (Strings.isNullOrEmpty((Object)this.getTypeName())) {
            result.fail((Throwable)new IllegalStateException("adapter does not define a typeName"));
        } else if (this.tenantClientFactory == null) {
            result.fail((Throwable)new IllegalStateException("Tenant client factory must be set"));
        } else if (this.downstreamSenderFactory == null) {
            result.fail((Throwable)new IllegalStateException("AMQP Messaging Network client must be set"));
        } else if (this.registrationClientFactory == null) {
            result.fail((Throwable)new IllegalStateException("Device Registration client factory must be set"));
        } else if (this.credentialsClientFactory == null) {
            result.fail((Throwable)new IllegalStateException("Credentials client factory must be set"));
        } else if (this.commandConsumerFactory == null) {
            result.fail((Throwable)new IllegalStateException("Command & Control client factory must be set"));
        } else {
            this.connectToService((ConnectionLifecycle)this.tenantClientFactory, "Tenant service");
            this.connectToService((ConnectionLifecycle)this.downstreamSenderFactory, "AMQP Messaging Network");
            this.connectToService((ConnectionLifecycle)this.registrationClientFactory, "Device Registration service");
            this.connectToService((ConnectionLifecycle)this.credentialsClientFactory, "Credentials service");
            this.connectToService((ConnectionLifecycle)this.commandConsumerFactory, "Command & Control", this::onCommandConnectionLost, this::onCommandConnectionEstablished).setHandler(c -> {
                if (c.succeeded()) {
                    this.onCommandConnectionEstablished((HonoConnection)c.result());
                }
            });
            this.doStart((Future<Void>)result);
        }
        return result;
    }

    protected void doStart(Future<Void> startFuture) {
        startFuture.complete();
    }

    @Override
    protected final Future<Void> stopInternal() {
        this.LOG.info("stopping protocol adapter");
        Future result = Future.future();
        Future doStopResult = Future.future();
        this.doStop((Future<Void>)doStopResult);
        doStopResult.compose(s -> this.closeServiceClients()).recover(t -> {
            this.LOG.info("error while stopping protocol adapter", t);
            return Future.failedFuture((Throwable)t);
        }).compose(s -> {
            result.complete();
            this.LOG.info("successfully stopped protocol adapter");
        }, result);
        return result;
    }

    private Future<?> closeServiceClients() {
        return CompositeFuture.all(this.disconnectFromService((ConnectionLifecycle)this.downstreamSenderFactory), this.disconnectFromService((ConnectionLifecycle)this.tenantClientFactory), this.disconnectFromService((ConnectionLifecycle)this.registrationClientFactory), this.disconnectFromService((ConnectionLifecycle)this.credentialsClientFactory), this.disconnectFromService((ConnectionLifecycle)this.commandConsumerFactory));
    }

    private Future<Void> disconnectFromService(ConnectionLifecycle connection) {
        Future disconnectTracker = Future.future();
        connection.disconnect((Handler)disconnectTracker);
        return disconnectTracker;
    }

    protected void doStop(Future<Void> stopFuture) {
        stopFuture.complete();
    }

    protected final Future<TenantObject> isAdapterEnabled(TenantObject tenantConfig) {
        Objects.requireNonNull(tenantConfig);
        if (tenantConfig.isAdapterEnabled(this.getTypeName())) {
            this.LOG.debug("protocol adapter [{}] is enabled for tenant [{}]", (Object)this.getTypeName(), (Object)tenantConfig.getTenantId());
            return Future.succeededFuture((Object)tenantConfig);
        }
        this.LOG.debug("protocol adapter [{}] is disabled for tenant [{}]", (Object)this.getTypeName(), (Object)tenantConfig.getTenantId());
        return Future.failedFuture((Throwable)new ClientErrorException(403, "adapter disabled for tenant"));
    }

    protected Future<Void> checkConnectionLimit(TenantObject tenantConfig) {
        Objects.requireNonNull(tenantConfig);
        return this.resourceLimitChecks.isConnectionLimitReached(tenantConfig).recover(t -> Future.succeededFuture((Object)Boolean.FALSE)).compose(isExceeded -> {
            if (isExceeded.booleanValue()) {
                return Future.failedFuture((Throwable)new ClientErrorException(403));
            }
            return Future.succeededFuture();
        });
    }

    protected final Future<ResourceIdentifier> validateAddress(ResourceIdentifier address, Device authenticatedDevice) {
        Objects.requireNonNull(address);
        Future result = Future.future();
        if (authenticatedDevice == null) {
            if (Strings.isNullOrEmpty((Object)address.getTenantId()) || Strings.isNullOrEmpty((Object)address.getResourceId())) {
                result.fail((Throwable)new ClientErrorException(400, "unauthenticated client must provide tenant and device ID in message address"));
            } else {
                result.complete((Object)address);
            }
        } else if (!Strings.isNullOrEmpty((Object)address.getTenantId()) && Strings.isNullOrEmpty((Object)address.getResourceId())) {
            result.fail((Throwable)new ClientErrorException(400, "message address must not contain tenant ID only"));
        } else if (!Strings.isNullOrEmpty((Object)address.getTenantId()) && !address.getTenantId().equals(authenticatedDevice.getTenantId())) {
            result.fail((Throwable)new ClientErrorException(403, "can only publish for device of same tenant"));
        } else if (Strings.isNullOrEmpty((Object)address.getTenantId()) && Strings.isNullOrEmpty((Object)address.getResourceId())) {
            ResourceIdentifier resource = ResourceIdentifier.from((ResourceIdentifier)address, (String)authenticatedDevice.getTenantId(), (String)authenticatedDevice.getDeviceId());
            result.complete((Object)resource);
        } else {
            result.complete((Object)address);
        }
        return result;
    }

    protected final Future<Void> checkDeviceRegistration(Device device, SpanContext context) {
        Objects.requireNonNull(device);
        return this.getRegistrationAssertion(device.getTenantId(), device.getDeviceId(), null, context).map(assertion -> null);
    }

    protected final Future<HonoConnection> connectToService(ConnectionLifecycle factory, String serviceName) {
        return this.connectToService(factory, serviceName, null, null);
    }

    protected final Future<HonoConnection> connectToService(ConnectionLifecycle factory, String serviceName, DisconnectListener disconnectListener, ReconnectListener reconnectListener) {
        Objects.requireNonNull(factory);
        factory.addDisconnectListener(c -> {
            this.LOG.info("lost connection to {}", (Object)serviceName);
            if (disconnectListener != null) {
                disconnectListener.onDisconnect(c);
            }
        });
        factory.addReconnectListener(c -> {
            this.LOG.info("connection to {} re-established", (Object)serviceName);
            if (reconnectListener != null) {
                reconnectListener.onReconnect(c);
            }
        });
        return factory.connect().map(c -> {
            this.LOG.info("connected to {}", (Object)serviceName);
            return c;
        }).recover(t -> {
            this.LOG.warn("failed to connect to {}", (Object)serviceName, t);
            return Future.failedFuture((Throwable)t);
        });
    }

    protected void onCommandConnectionLost(HonoConnection commandConnection) {
    }

    protected void onCommandConnectionEstablished(HonoConnection commandConnection) {
    }

    protected Future<Void> isConnected() {
        Future tenantCheck = Optional.ofNullable(this.tenantClientFactory).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new ServerErrorException(503, "Tenant client factory is not set")));
        Future registrationCheck = Optional.ofNullable(this.registrationClientFactory).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new ServerErrorException(503, "Device Registration client factory is not set")));
        Future credentialsCheck = Optional.ofNullable(this.credentialsClientFactory).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new ServerErrorException(503, "Credentials client factory is not set")));
        Future messagingCheck = Optional.ofNullable(this.downstreamSenderFactory).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new ServerErrorException(503, "Messaging client is not set")));
        Future commandCheck = Optional.ofNullable(this.commandConsumerFactory).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new ServerErrorException(503, "Command & Control client factory is not set")));
        return CompositeFuture.all((Future)tenantCheck, (Future)registrationCheck, (Future)credentialsCheck, (Future)messagingCheck, (Future)commandCheck).map(ok -> null);
    }

    protected final Future<MessageConsumer> createCommandConsumer(String tenantId, String deviceId, Handler<CommandContext> commandConsumer, Handler<Void> closeHandler) {
        return this.commandConsumerFactory.createCommandConsumer(tenantId, deviceId, commandContext -> {
            Tags.COMPONENT.set(commandContext.getCurrentSpan(), this.getTypeName());
            commandConsumer.handle(commandContext);
        }, closeHandler);
    }

    @Deprecated
    protected final void closeCommandConsumer(String tenantId, String deviceId) {
        this.getCommandConsumerFactory().closeCommandConsumer(tenantId, deviceId).otherwise(t -> {
            this.LOG.warn("cannot close command consumer [tenant-id: {}, device-id: {}]: {}", new Object[]{tenantId, deviceId, t.getMessage()});
            return null;
        });
    }

    protected final Future<CommandResponseSender> createCommandResponseSender(String tenantId, String replyId) {
        return this.commandConsumerFactory.getCommandResponseSender(tenantId, replyId);
    }

    protected final Future<ProtonDelivery> sendCommandResponse(String tenantId, CommandResponse response, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(response);
        Future<CommandResponseSender> senderTracker = this.createCommandResponseSender(tenantId, response.getReplyToId());
        return senderTracker.compose(sender -> sender.sendCommandResponse(response, context)).map(delivery -> {
            ((CommandResponseSender)senderTracker.result()).close(c -> {});
            return delivery;
        }).recover(t -> {
            if (senderTracker.succeeded()) {
                ((CommandResponseSender)senderTracker.result()).close(c -> {});
            }
            return Future.failedFuture((Throwable)t);
        });
    }

    protected final Future<DownstreamSender> getTelemetrySender(String tenantId) {
        return this.getDownstreamSenderFactory().getOrCreateTelemetrySender(tenantId);
    }

    protected final Future<DownstreamSender> getEventSender(String tenantId) {
        return this.getDownstreamSenderFactory().getOrCreateEventSender(tenantId);
    }

    protected final Future<RegistrationClient> getRegistrationClient(String tenantId) {
        return this.getRegistrationClientFactory().getOrCreateRegistrationClient(tenantId);
    }

    @Deprecated
    protected final Future<JsonObject> getRegistrationAssertion(String tenantId, String deviceId, Device authenticatedDevice) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Future<String> gatewayId = this.getGatewayId(tenantId, deviceId, authenticatedDevice);
        return gatewayId.compose(gwId -> this.getRegistrationClient(tenantId)).compose(client -> client.assertRegistration(deviceId, (String)gatewayId.result()));
    }

    protected final Future<JsonObject> getRegistrationAssertion(String tenantId, String deviceId, Device authenticatedDevice, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Future<String> gatewayId = this.getGatewayId(tenantId, deviceId, authenticatedDevice);
        return gatewayId.compose(gwId -> this.getRegistrationClient(tenantId)).compose(client -> client.assertRegistration(deviceId, (String)gatewayId.result(), context));
    }

    private Future<String> getGatewayId(String tenantId, String deviceId, Device authenticatedDevice) {
        Future result = Future.future();
        if (authenticatedDevice == null) {
            result.complete(null);
        } else if (tenantId.equals(authenticatedDevice.getTenantId())) {
            if (deviceId.equals(authenticatedDevice.getDeviceId())) {
                result.complete(null);
            } else {
                result.complete((Object)authenticatedDevice.getDeviceId());
            }
        } else {
            result.fail((Throwable)new ClientErrorException(403, "cannot publish data for device of other tenant"));
        }
        return result;
    }

    @Deprecated
    protected final Future<TenantObject> getTenantConfiguration(String tenantId) {
        Objects.requireNonNull(tenantId);
        return this.getTenantClient().compose(client -> client.get(tenantId));
    }

    protected final Future<TenantObject> getTenantConfiguration(String tenantId, SpanContext context) {
        Objects.requireNonNull(tenantId);
        return this.getTenantClient().compose(client -> client.get(tenantId, context));
    }

    protected final Message newMessage(ResourceIdentifier target, String publishAddress, String contentType, Buffer payload, JsonObject registrationInfo, Integer timeUntilDisconnect) {
        Objects.requireNonNull(target);
        Objects.requireNonNull(registrationInfo);
        Message msg = ProtonHelper.message();
        MessageHelper.setPayload((Message)msg, (String)contentType, (Buffer)payload);
        msg.setContentType(contentType);
        return this.addProperties(msg, target, publishAddress, registrationInfo, timeUntilDisconnect);
    }

    protected final Message addProperties(Message msg, ResourceIdentifier target, String publishAddress, JsonObject registrationInfo, Integer timeUntilDisconnect) {
        Objects.requireNonNull(msg);
        Objects.requireNonNull(target);
        Objects.requireNonNull(registrationInfo);
        msg.setAddress(target.getBasePath());
        MessageHelper.addDeviceId((Message)msg, (String)target.getResourceId());
        MessageHelper.annotate((Message)msg, (ResourceIdentifier)target);
        if (publishAddress != null) {
            MessageHelper.addProperty((Message)msg, (String)"orig_address", (Object)publishAddress);
        }
        if (timeUntilDisconnect != null) {
            MessageHelper.addTimeUntilDisconnect((Message)msg, (int)timeUntilDisconnect);
        }
        MessageHelper.setCreationTime((Message)msg);
        this.addProperties(msg, registrationInfo);
        return msg;
    }

    protected final void addProperties(Message message, JsonObject registrationInfo) {
        JsonObject defaults;
        MessageHelper.addProperty((Message)message, (String)"orig_adapter", (Object)this.getTypeName());
        if (((ProtocolAdapterProperties)this.getConfig()).isDefaultsEnabled() && (defaults = registrationInfo.getJsonObject("defaults")) != null) {
            this.addDefaults(message, defaults);
        }
        if (Strings.isNullOrEmpty((Object)message.getContentType())) {
            message.setContentType(CONTENT_TYPE_OCTET_STREAM);
        }
        if (((ProtocolAdapterProperties)this.getConfig()).isJmsVendorPropsEnabled()) {
            MessageHelper.addJmsVendorProperties((Message)message);
        }
    }

    private void addDefaults(Message message, JsonObject defaults) {
        defaults.forEach(prop -> {
            switch ((String)prop.getKey()) {
                case "content-type": {
                    if (!Strings.isNullOrEmpty((Object)message.getContentType()) || !String.class.isInstance(prop.getValue())) break;
                    message.setContentType((String)prop.getValue());
                    break;
                }
                case "content-encoding": {
                    if (!Strings.isNullOrEmpty((Object)message.getContentEncoding()) || !String.class.isInstance(prop.getValue())) break;
                    message.setContentEncoding((String)prop.getValue());
                    break;
                }
                case "absolute-expiry-time": 
                case "correlation-id": 
                case "creation-time": 
                case "group-id": 
                case "group-sequence": 
                case "message-id": 
                case "reply-to": 
                case "reply-to-group-id": 
                case "subject": 
                case "to": 
                case "user-id": {
                    this.LOG.debug("ignoring default property [{}] registered for device", prop.getKey());
                    break;
                }
                default: {
                    MessageHelper.addProperty((Message)message, (String)((String)prop.getKey()), prop.getValue());
                }
            }
        });
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler handler) {
        handler.register("connection-to-services", status -> this.isConnected().map(connected -> {
            status.tryComplete((Object)Status.OK());
            return null;
        }).otherwise(t -> {
            status.tryComplete((Object)Status.KO());
            return null;
        }));
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler handler) {
        this.registerEventLoopBlockedCheck(handler);
    }

    protected Future<?> sendConnectedEvent(String remoteId, Device authenticatedDevice) {
        if (this.connectionEventProducer != null) {
            return this.connectionEventProducer.connected(this.connectionEventProducerContext, remoteId, this.getTypeName(), authenticatedDevice, null);
        }
        return Future.succeededFuture();
    }

    protected Future<?> sendDisconnectedEvent(String remoteId, Device authenticatedDevice) {
        if (this.connectionEventProducer != null) {
            return this.connectionEventProducer.disconnected(this.connectionEventProducerContext, remoteId, this.getTypeName(), authenticatedDevice, null);
        }
        return Future.succeededFuture();
    }

    @Deprecated
    protected final Future<ProtonDelivery> sendConnectedTtdEvent(String tenant, String deviceId, Device authenticatedDevice) {
        return this.sendConnectedTtdEvent(tenant, deviceId, authenticatedDevice, null);
    }

    protected final Future<ProtonDelivery> sendConnectedTtdEvent(String tenant, String deviceId, Device authenticatedDevice, SpanContext context) {
        return this.sendTtdEvent(tenant, deviceId, authenticatedDevice, -1, context);
    }

    @Deprecated
    protected final Future<ProtonDelivery> sendDisconnectedTtdEvent(String tenant, String deviceId, Device authenticatedDevice) {
        return this.sendDisconnectedTtdEvent(tenant, deviceId, authenticatedDevice, null);
    }

    protected final Future<ProtonDelivery> sendDisconnectedTtdEvent(String tenant, String deviceId, Device authenticatedDevice, SpanContext context) {
        return this.sendTtdEvent(tenant, deviceId, authenticatedDevice, 0, context);
    }

    @Deprecated
    protected final Future<ProtonDelivery> sendTtdEvent(String tenant, String deviceId, Device authenticatedDevice, Integer ttd) {
        return this.sendTtdEvent(tenant, deviceId, authenticatedDevice, ttd, null);
    }

    protected final Future<ProtonDelivery> sendTtdEvent(String tenant, String deviceId, Device authenticatedDevice, Integer ttd, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(ttd);
        Future<JsonObject> tokenTracker = this.getRegistrationAssertion(tenant, deviceId, authenticatedDevice, context);
        Future<TenantObject> tenantConfigTracker = this.getTenantConfiguration(tenant, context);
        Future<DownstreamSender> senderTracker = this.getEventSender(tenant);
        return CompositeFuture.all(tokenTracker, tenantConfigTracker, senderTracker).compose(ok -> {
            if (((TenantObject)tenantConfigTracker.result()).isAdapterEnabled(this.getTypeName())) {
                DownstreamSender sender = (DownstreamSender)senderTracker.result();
                Message msg = this.newMessage(ResourceIdentifier.from((String)"event", (String)tenant, (String)deviceId), "event", "application/vnd.eclipse-hono-empty-notification", null, (JsonObject)tokenTracker.result(), ttd);
                return sender.sendAndWaitForOutcome(msg, context);
            }
            return Future.failedFuture((Throwable)new ClientErrorException(403));
        });
    }

    protected boolean isPayloadOfIndicatedType(Buffer payload, String contentType) {
        if (payload == null || payload.length() == 0) {
            return "application/vnd.eclipse-hono-empty-notification".equals(contentType);
        }
        return !"application/vnd.eclipse-hono-empty-notification".equals(contentType);
    }

    protected void onCloseCommandConsumer(String tenant, String deviceId, BiConsumer<ProtonDelivery, Message> commandMessageConsumer) {
        this.LOG.debug("command consumer closed [tenantId: {}, deviceId: {}] - no command will be received for this device anymore", (Object)tenant, (Object)deviceId);
    }

    protected void registerEventLoopBlockedCheck(HealthCheckHandler handler) {
        handler.register("event-loop-blocked-check", ((ProtocolAdapterProperties)this.getConfig()).getEventLoopBlockedCheckTimeout(), procedure -> {
            Context currentContext = Vertx.currentContext();
            if (currentContext != this.context) {
                this.context.runOnContext(action -> procedure.complete((Object)Status.OK()));
            } else {
                this.LOG.info("Protocol Adapter - HealthCheck Server context match. Assume protocol adapter is alive.");
                procedure.complete((Object)Status.OK());
            }
        });
    }

    @Override
    protected TrustOptions getServerTrustOptions() {
        return Optional.ofNullable(((ProtocolAdapterProperties)this.getConfig()).getTrustOptions()).orElseGet(() -> {
            if (((ProtocolAdapterProperties)this.getConfig()).isAuthenticationRequired()) {
                return new ValidityBasedTrustOptions();
            }
            return null;
        });
    }

    public final ConnectionLimitManager getConnectionLimitManager() {
        return this.connectionLimitManager;
    }

    public final void setConnectionLimitManager(ConnectionLimitManager connectionLimitManager) {
        this.connectionLimitManager = connectionLimitManager;
    }
}

