/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.metric;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.eclipse.hono.service.metric.LegacyMetrics;
import org.eclipse.hono.service.metric.Metrics;
import org.eclipse.hono.service.metric.MetricsTags;

public class MicrometerBasedMetrics
implements Metrics {
    public static final String METER_CONNECTIONS_AUTHENTICATED = "hono.connections.authenticated";
    public static final String METER_CONNECTIONS_UNAUTHENTICATED = "hono.connections.unauthenticated";
    public static final String METER_MESSAGES_PAYLOAD = "hono.messages.payload";
    public static final String METER_MESSAGES_RECEIVED = "hono.messages.received";
    public static final String METER_COMMANDS_PAYLOAD = "hono.commands.payload";
    public static final String METER_COMMANDS_RECEIVED = "hono.commands.received";
    protected final MeterRegistry registry;
    private final Map<String, AtomicLong> authenticatedConnections = new ConcurrentHashMap<String, AtomicLong>();
    private final AtomicLong unauthenticatedConnections;
    private final AtomicLong totalCurrentConnections = new AtomicLong();
    private LegacyMetrics legacyMetrics;

    protected MicrometerBasedMetrics(MeterRegistry registry) {
        Objects.requireNonNull(registry);
        this.registry = registry;
        this.unauthenticatedConnections = (AtomicLong)registry.gauge(METER_CONNECTIONS_UNAUTHENTICATED, (Number)new AtomicLong());
    }

    public final void setLegacyMetrics(LegacyMetrics legacyMetrics) {
        this.legacyMetrics = legacyMetrics;
    }

    @Override
    public final void incrementConnections(String tenantId) {
        Objects.requireNonNull(tenantId);
        this.gaugeForTenant(METER_CONNECTIONS_AUTHENTICATED, this.authenticatedConnections, tenantId, AtomicLong::new).incrementAndGet();
        this.totalCurrentConnections.incrementAndGet();
    }

    @Override
    public final void decrementConnections(String tenantId) {
        Objects.requireNonNull(tenantId);
        this.gaugeForTenant(METER_CONNECTIONS_AUTHENTICATED, this.authenticatedConnections, tenantId, AtomicLong::new).decrementAndGet();
        this.totalCurrentConnections.decrementAndGet();
    }

    @Override
    public final void incrementUnauthenticatedConnections() {
        this.unauthenticatedConnections.incrementAndGet();
        this.totalCurrentConnections.incrementAndGet();
    }

    @Override
    public final void decrementUnauthenticatedConnections() {
        this.unauthenticatedConnections.decrementAndGet();
        this.totalCurrentConnections.decrementAndGet();
    }

    @Override
    public long getNumberOfConnections() {
        return this.totalCurrentConnections.get();
    }

    @Override
    public Timer.Sample startTimer() {
        return Timer.start((MeterRegistry)this.registry);
    }

    @Override
    public final void reportTelemetry(MetricsTags.EndpointType type, String tenantId, MetricsTags.ProcessingOutcome outcome, MetricsTags.QoS qos, int payloadSize, Timer.Sample timer) {
        this.reportTelemetry(type, tenantId, outcome, qos, payloadSize, MetricsTags.TtdStatus.NONE, timer);
    }

    @Override
    public final void reportTelemetry(MetricsTags.EndpointType type, String tenantId, MetricsTags.ProcessingOutcome outcome, MetricsTags.QoS qos, int payloadSize, MetricsTags.TtdStatus ttdStatus, Timer.Sample timer) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(outcome);
        Objects.requireNonNull(qos);
        Objects.requireNonNull(ttdStatus);
        Objects.requireNonNull(timer);
        if (type != MetricsTags.EndpointType.TELEMETRY && type != MetricsTags.EndpointType.EVENT) {
            throw new IllegalArgumentException("invalid type, must be either telemetry or event");
        }
        if (payloadSize < 0) {
            throw new IllegalArgumentException("payload size must not be negative");
        }
        Tags baseTags = Tags.of((Tag[])new Tag[]{type.asTag()}).and(new Tag[]{MetricsTags.getTenantTag(tenantId)}).and(new Tag[]{outcome.asTag()});
        timer.stop(this.registry.timer(METER_MESSAGES_RECEIVED, (Iterable)ttdStatus.add(qos.add(baseTags))));
        DistributionSummary.builder((String)METER_MESSAGES_PAYLOAD).baseUnit("bytes").minimumExpectedValue(Long.valueOf(0L)).tags((Iterable)baseTags).register(this.registry).record((double)payloadSize);
        if (this.legacyMetrics != null) {
            switch (outcome) {
                case FORWARDED: {
                    this.legacyMetrics.incrementProcessedMessages(type, tenantId);
                    break;
                }
                case UNDELIVERABLE: {
                    this.legacyMetrics.incrementUndeliverableMessages(type, tenantId);
                    break;
                }
            }
            switch (ttdStatus) {
                case EXPIRED: {
                    this.legacyMetrics.incrementNoCommandReceivedAndTTDExpired(tenantId);
                    break;
                }
            }
        }
    }

    @Override
    public void reportCommand(MetricsTags.Direction direction, String tenantId, MetricsTags.ProcessingOutcome outcome, int payloadSize, Timer.Sample timer) {
        Objects.requireNonNull(direction);
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(outcome);
        Objects.requireNonNull(timer);
        if (payloadSize < 0) {
            throw new IllegalArgumentException("payload size must not be negative");
        }
        Tags baseTags = Tags.of((Tag[])new Tag[]{direction.asTag()}).and(new Tag[]{MetricsTags.getTenantTag(tenantId)}).and(new Tag[]{outcome.asTag()});
        timer.stop(this.registry.timer(METER_COMMANDS_RECEIVED, (Iterable)baseTags));
        DistributionSummary.builder((String)METER_COMMANDS_PAYLOAD).baseUnit("bytes").minimumExpectedValue(Long.valueOf(0L)).tags((Iterable)baseTags).register(this.registry).record((double)payloadSize);
        if (this.legacyMetrics != null) {
            switch (direction) {
                case ONE_WAY: 
                case REQUEST: {
                    this.legacyMetrics.incrementCommandDeliveredToDevice(tenantId);
                    break;
                }
                case RESPONSE: {
                    this.legacyMetrics.incrementCommandResponseDeliveredToApplication(tenantId);
                }
            }
        }
    }

    protected <K, V extends Number> V gaugeForKey(String name, Map<K, V> map, K key, Tags tags, Supplier<V> instanceSupplier) {
        return (V)map.computeIfAbsent(key, a -> this.registry.gauge(name, (Iterable)tags, (Number)instanceSupplier.get()));
    }

    protected <V extends Number> V gaugeForTenant(String name, Map<String, V> map, String tenant, Supplier<V> instanceSupplier) {
        return this.gaugeForKey(name, map, tenant, Tags.of((Tag[])new Tag[]{MetricsTags.getTenantTag(tenant)}), instanceSupplier);
    }
}

