/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.metric;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.graphite.GraphiteConfig;
import io.micrometer.graphite.GraphiteHierarchicalNameMapper;
import io.micrometer.graphite.GraphiteMeterRegistry;
import io.micrometer.spring.autoconfigure.MeterRegistryCustomizer;
import io.vertx.core.metrics.MetricsOptions;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;

@PropertySource(value={"classpath:org/eclipse/hono/service/metric/legacy.properties"})
public abstract class AbstractLegacyMetricsConfig {
    protected static final String TAG_HONO = "hono";
    protected static final String TAG_PROTOCOL = "protocol";
    protected static final String TAG_METER_TYPE = "meterType";
    protected static final String TAG_SUB_NAME = "subName";
    protected static final String TAG_TYPE_SUFFIX = "typeSuffix";
    private static final Map<String, String> protocols = new HashMap<String, String>(5);
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Bean
    public MetricsOptions metricsOptions() {
        return new MetricsOptions();
    }

    @Bean
    public GraphiteMeterRegistry graphiteMeterRegistry(GraphiteConfig config, Clock clock) {
        return new GraphiteMeterRegistry(config, clock, this.legacyGraphiteFormatMapper(new GraphiteHierarchicalNameMapper(config.tagsAsPrefix())));
    }

    public HierarchicalNameMapper legacyGraphiteFormatMapper(GraphiteHierarchicalNameMapper defaultMapper) {
        return (id, convention) -> {
            if (id.getTag(TAG_HONO) == null) {
                return defaultMapper.toHierarchicalName(id, convention);
            }
            return this.amendWithTags(id.getConventionName(convention), id, new String[]{"host", TAG_METER_TYPE, TAG_HONO, TAG_PROTOCOL}, new String[]{"type", "tenant", TAG_SUB_NAME, TAG_TYPE_SUFFIX});
        };
    }

    @Bean
    public MeterRegistryCustomizer<GraphiteMeterRegistry> legacyMeterFilters() {
        return r -> {
            r.config().namingConvention(NamingConvention.dot);
            for (MeterFilter filter : this.getMeterFilters()) {
                r.config().meterFilter(filter);
            }
        };
    }

    public MeterFilter[] getMeterFilters() {
        return new MeterFilter[]{MeterFilter.denyNameStartsWith((String)"hono.messages.received"), MeterFilter.denyNameStartsWith((String)"hono.messages.payload"), MeterFilter.replaceTagValues((String)"host", host -> host.replace('.', '_'), (String[])new String[0]), MeterFilter.replaceTagValues((String)"tenant", tenant -> tenant.replace('.', '_'), (String[])new String[0]), MeterFilter.ignoreTags((String[])new String[]{"component-type", "qos", "status", "ttd"}), this.meterTypeMapper()};
    }

    protected abstract MeterFilter meterTypeMapper();

    protected final String getProtocolForComponentName(String componentName) {
        return protocols.getOrDefault(componentName, componentName);
    }

    private String amendWithTags(String name, Meter.Id id, String[] prefixTags, String[] suffixTags) {
        StringBuilder sb = new StringBuilder();
        AbstractLegacyMetricsConfig.addTags(sb, id, prefixTags);
        if (sb.length() > 0) {
            sb.append('.');
            sb.append(name);
        }
        AbstractLegacyMetricsConfig.addTags(sb, id, suffixTags);
        String result = sb.toString();
        this.log.trace("mapping meter [{}] and tags to [{}]", (Object)name, (Object)result);
        return result;
    }

    private static void addTags(StringBuilder sb, Meter.Id id, String[] tags) {
        for (String tag : tags) {
            String value = id.getTag(tag);
            if (value == null) continue;
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(value.replace(' ', '_'));
        }
    }

    static {
        protocols.put("hono-amqp", "amqp");
        protocols.put("hono-coap", "coap");
        protocols.put("hono-http", "http");
        protocols.put("hono-kura-mqtt", "kura");
        protocols.put("hono-mqtt", "mqtt");
        protocols.put("hono-messaging", "messaging");
    }
}

