/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.credentials;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import java.util.Objects;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.RequestResponseEndpoint;
import org.eclipse.hono.service.credentials.CredentialsMessageFilter;
import org.eclipse.hono.util.CredentialsConstants;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.ResourceIdentifier;
import org.springframework.beans.factory.annotation.Autowired;

public class CredentialsAmqpEndpoint
extends RequestResponseEndpoint<ServiceConfigProperties> {
    @Autowired
    public CredentialsAmqpEndpoint(Vertx vertx) {
        super(Objects.requireNonNull(vertx));
    }

    @Override
    public final String getName() {
        return "credentials";
    }

    @Override
    public final void processRequest(Message msg, ResourceIdentifier targetAddress, HonoUser clientPrincipal) {
        EventBusMessage credentialsMsg = EventBusMessage.forOperation((Message)msg).setReplyToAddress(msg).setAppCorrelationId(msg).setCorrelationId(msg).setTenant(targetAddress.getTenantId()).setJsonPayload(msg);
        DeliveryOptions options = this.createEventBusMessageDeliveryOptions(this.extractSpanContext(msg));
        this.vertx.eventBus().send("credentials.in", (Object)credentialsMsg.toJson(), options);
    }

    @Override
    protected boolean passesFormalVerification(ResourceIdentifier linkTarget, Message msg) {
        return CredentialsMessageFilter.verify(linkTarget, msg);
    }

    @Override
    protected final Message getAmqpReply(EventBusMessage message) {
        return CredentialsConstants.getAmqpReply((String)"credentials", (EventBusMessage)message);
    }
}

