/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.opentracing.Tracer;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.auth.HonoPasswordEncoder;
import org.eclipse.hono.auth.SpringBasedHonoPasswordEncoder;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.auth.device.CredentialsApiAuthProvider;
import org.eclipse.hono.service.auth.device.UsernamePasswordCredentials;
import org.eclipse.hono.util.CredentialsObject;
import org.springframework.beans.factory.annotation.Autowired;

public final class UsernamePasswordAuthProvider
extends CredentialsApiAuthProvider<UsernamePasswordCredentials> {
    private final ServiceConfigProperties config;
    private final HonoPasswordEncoder pwdEncoder;

    @Autowired
    public UsernamePasswordAuthProvider(HonoClient credentialsServiceClient, ServiceConfigProperties config, Tracer tracer) {
        this(credentialsServiceClient, (HonoPasswordEncoder)new SpringBasedHonoPasswordEncoder(), config, tracer);
    }

    @Autowired
    public UsernamePasswordAuthProvider(HonoClient credentialsServiceClient, HonoPasswordEncoder pwdEncoder, ServiceConfigProperties config, Tracer tracer) {
        super(credentialsServiceClient, tracer);
        this.config = Objects.requireNonNull(config);
        this.pwdEncoder = Objects.requireNonNull(pwdEncoder);
    }

    @Override
    protected UsernamePasswordCredentials getCredentials(JsonObject authInfo) {
        try {
            String username = authInfo.getString("username");
            String password = authInfo.getString("password");
            if (username == null || password == null) {
                return null;
            }
            return UsernamePasswordCredentials.create(username, password, this.config.isSingleTenant());
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    protected Future<Device> doValidateCredentials(UsernamePasswordCredentials deviceCredentials, CredentialsObject credentialsOnRecord) {
        Context currentContext = Vertx.currentContext();
        if (currentContext == null) {
            return Future.failedFuture((Throwable)new IllegalStateException("not running on vert.x Context"));
        }
        Future result = Future.future();
        currentContext.executeBlocking(blockingCodeHandler -> {
            this.log.debug("validating password hash on vert.x worker thread [{}]", (Object)Thread.currentThread().getName());
            boolean isValid = credentialsOnRecord.getCandidateSecrets().stream().anyMatch(candidateSecret -> this.pwdEncoder.matches(deviceCredentials.getPassword(), candidateSecret));
            if (isValid) {
                blockingCodeHandler.complete((Object)new Device(deviceCredentials.getTenantId(), credentialsOnRecord.getDeviceId()));
            } else {
                blockingCodeHandler.fail((Throwable)new ClientErrorException(401, "bad credentials"));
            }
        }, false, (Handler)result);
        return result;
    }
}

