/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tenant;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.http.AbstractHttpEndpoint;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.TenantConstants;
import org.springframework.beans.factory.annotation.Autowired;

public final class TenantHttpEndpoint
extends AbstractHttpEndpoint<ServiceConfigProperties> {
    @Autowired
    public TenantHttpEndpoint(Vertx vertx) {
        super(Objects.requireNonNull(vertx));
    }

    @Override
    protected String getEventBusAddress() {
        return "tenant.in";
    }

    @Override
    public String getName() {
        return "tenant";
    }

    @Override
    public void addRoutes(Router router) {
        String path = String.format("/%s", "tenant");
        BodyHandler bodyHandler = BodyHandler.create();
        bodyHandler.setBodyLimit((long)((ServiceConfigProperties)this.config).getMaxPayloadSize());
        router.post(path).handler((Handler)bodyHandler);
        router.post(path).handler(this::extractRequiredJsonPayload);
        router.post(path).handler(this::checkPayloadForTenantId);
        router.post(path).handler(this::addTenant);
        String pathWithTenant = String.format("/%s/:%s", "tenant", "tenant_id");
        router.get(pathWithTenant).handler(this::getTenant);
        router.put(pathWithTenant).handler((Handler)bodyHandler);
        router.put(pathWithTenant).handler(this::extractRequiredJsonPayload);
        router.put(pathWithTenant).handler(this::updateTenant);
        router.delete(pathWithTenant).handler(this::removeTenant);
    }

    protected void checkPayloadForTenantId(RoutingContext ctx) {
        JsonObject payload = (JsonObject)ctx.get("KEY_REQUEST_BODY");
        Object tenantId = payload.getValue("tenant-id");
        if (tenantId == null) {
            ctx.fail((Throwable)new ClientErrorException(400, String.format("'%s' param is required", "tenant-id")));
        } else if (!(tenantId instanceof String)) {
            ctx.fail((Throwable)new ClientErrorException(400, String.format(String.format("'%s' must be a string", "tenant-id"), new Object[0])));
        }
        ctx.next();
    }

    private String getTenantIdFromContext(RoutingContext ctx) {
        JsonObject payload = (JsonObject)ctx.get("KEY_REQUEST_BODY");
        return Optional.ofNullable(this.getTenantParam(ctx)).orElse(TenantHttpEndpoint.getTenantParamFromPayload(payload));
    }

    private void addTenant(RoutingContext ctx) {
        String tenantId = this.getTenantIdFromContext(ctx);
        String location = String.format("/%s/%s", "tenant", tenantId);
        this.doTenantHttpRequest(ctx, tenantId, TenantConstants.TenantAction.add, status -> status == 201, (Handler<HttpServerResponse>)((Handler)response -> response.putHeader(HttpHeaders.LOCATION, (CharSequence)location)));
    }

    private void getTenant(RoutingContext ctx) {
        String tenantId = this.getTenantIdFromContext(ctx);
        this.doTenantHttpRequest(ctx, tenantId, TenantConstants.TenantAction.get, status -> status == 200, null);
    }

    private void updateTenant(RoutingContext ctx) {
        String tenantId = this.getTenantIdFromContext(ctx);
        this.doTenantHttpRequest(ctx, tenantId, TenantConstants.TenantAction.update, status -> status == 204, null);
    }

    private void removeTenant(RoutingContext ctx) {
        String tenantId = this.getTenantIdFromContext(ctx);
        this.doTenantHttpRequest(ctx, tenantId, TenantConstants.TenantAction.remove, status -> status == 204, null);
    }

    private void doTenantHttpRequest(RoutingContext ctx, String tenantId, TenantConstants.TenantAction action, Predicate<Integer> successfulOutcomeFilter, Handler<HttpServerResponse> httpServerResponseHandler) {
        this.logger.debug("http request [{}] for tenant [tenant: {}]", (Object)action, (Object)tenantId);
        JsonObject payload = (JsonObject)ctx.get("KEY_REQUEST_BODY");
        JsonObject requestMsg = EventBusMessage.forOperation((String)action.toString()).setTenant(tenantId).setJsonPayload(payload).toJson();
        this.sendAction(ctx, requestMsg, this.getDefaultResponseHandler(ctx, successfulOutcomeFilter, httpServerResponseHandler));
    }

    private static String getTenantParamFromPayload(JsonObject payload) {
        return payload != null ? (String)payload.remove("tenant-id") : null;
    }
}

