/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tenant;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.tenant.BaseTenantService;
import org.eclipse.hono.service.tenant.CompleteTenantService;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.TenantConstants;
import org.eclipse.hono.util.TenantResult;

public abstract class CompleteBaseTenantService<T>
extends BaseTenantService<T>
implements CompleteTenantService {
    @Override
    public final Future<EventBusMessage> processRequest(EventBusMessage request) {
        Objects.requireNonNull(request);
        switch (TenantConstants.TenantAction.from((String)request.getOperation())) {
            case add: {
                return this.processAddRequest(request);
            }
            case get: {
                return this.processGetRequest(request);
            }
            case update: {
                return this.processUpdateRequest(request);
            }
            case remove: {
                return this.processRemoveRequest(request);
            }
        }
        return this.processCustomTenantMessage(request);
    }

    private Future<EventBusMessage> processAddRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        JsonObject payload = this.getRequestPayload(request.getJsonPayload());
        if (tenantId == null) {
            this.log.debug("request does not contain mandatory property [{}]", (Object)"tenant_id");
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (this.isValidRequestPayload(payload)) {
            this.log.debug("creating tenant [{}]", (Object)tenantId);
            Future addResult = Future.future();
            this.addNotPresentFieldsWithDefaultValuesForTenant(payload);
            this.add(tenantId, payload, (Handler<AsyncResult<TenantResult<JsonObject>>>)addResult.completer());
            return addResult.map(tr -> request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setCacheDirective(tr.getCacheDirective()));
        }
        this.log.debug("request contains malformed payload");
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    private Future<EventBusMessage> processUpdateRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        JsonObject payload = this.getRequestPayload(request.getJsonPayload());
        if (tenantId == null) {
            this.log.debug("request does not contain mandatory property [{}]", (Object)"tenant_id");
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (this.isValidRequestPayload(payload)) {
            this.log.debug("updating tenant [{}]", (Object)tenantId);
            Future updateResult = Future.future();
            this.addNotPresentFieldsWithDefaultValuesForTenant(payload);
            this.update(tenantId, payload, (Handler<AsyncResult<TenantResult<JsonObject>>>)updateResult.completer());
            return updateResult.map(tr -> request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setCacheDirective(tr.getCacheDirective()));
        }
        this.log.debug("request contains malformed payload");
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    private Future<EventBusMessage> processRemoveRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        if (tenantId == null) {
            this.log.debug("request does not contain mandatory property [{}]", (Object)"tenant_id");
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("deleting tenant [{}]", (Object)tenantId);
        Future removeResult = Future.future();
        this.remove(tenantId, (Handler<AsyncResult<TenantResult<JsonObject>>>)removeResult.completer());
        return removeResult.map(tr -> request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setCacheDirective(tr.getCacheDirective()));
    }

    private boolean isValidRequestPayload(JsonObject payload) {
        return this.hasValidAdapterSpec(payload) && this.hasValidTrustedCaSpec(payload);
    }

    private boolean hasValidAdapterSpec(JsonObject payload) {
        Object adaptersObj = payload.getValue("adapters");
        if (adaptersObj instanceof JsonArray) {
            JsonArray adapters = (JsonArray)adaptersObj;
            if (adapters.size() == 0) {
                return false;
            }
            boolean containsInvalidAdapter = adapters.stream().anyMatch(obj -> !(obj instanceof JsonObject) || !((JsonObject)obj).containsKey("type"));
            if (containsInvalidAdapter) {
                return false;
            }
        } else if (adaptersObj != null) {
            return false;
        }
        return true;
    }

    private boolean hasValidTrustedCaSpec(JsonObject payload) {
        Object trustedCaObj = payload.getValue("trusted-ca");
        if (trustedCaObj instanceof JsonObject) {
            JsonObject trustedCa = (JsonObject)trustedCaObj;
            if (!(trustedCa.getValue("subject-dn") instanceof String)) {
                return false;
            }
            Object cert = trustedCa.getValue("cert");
            Object pk = trustedCa.getValue("public-key");
            if (cert == null && pk == null) {
                return false;
            }
            if (cert != null && pk != null) {
                return false;
            }
            if (cert != null && !(cert instanceof String)) {
                return false;
            }
            if (pk != null && !(pk instanceof String)) {
                return false;
            }
        } else if (trustedCaObj != null) {
            return false;
        }
        return true;
    }

    protected final void addNotPresentFieldsWithDefaultValuesForTenant(JsonObject checkedPayload) {
        JsonArray adapters;
        if (!checkedPayload.containsKey("enabled")) {
            this.log.trace("adding 'enabled' key to payload");
            checkedPayload.put("enabled", Boolean.TRUE);
        }
        if ((adapters = checkedPayload.getJsonArray("adapters")) != null) {
            adapters.forEach(elem -> this.addNotPresentFieldsWithDefaultValuesForAdapter((JsonObject)elem));
        }
    }

    private void addNotPresentFieldsWithDefaultValuesForAdapter(JsonObject adapter) {
        if (!adapter.containsKey("enabled")) {
            this.log.trace("adding 'enabled' key to payload");
            adapter.put("enabled", Boolean.TRUE);
        }
        if (!adapter.containsKey("device-authentication-required")) {
            this.log.trace("adding 'device-authentication-required' key to adapter payload");
            adapter.put("device-authentication-required", Boolean.TRUE);
        }
    }

    @Override
    public void add(String tenantId, JsonObject tenantObj, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void update(String tenantId, JsonObject tenantObj, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void remove(String tenantId, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }
}

