/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.registration.BaseRegistrationService;
import org.eclipse.hono.service.registration.CompleteRegistrationService;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.RegistrationResult;

public abstract class CompleteBaseRegistrationService<T>
extends BaseRegistrationService<T>
implements CompleteRegistrationService {
    @Override
    public final Future<EventBusMessage> processRequest(EventBusMessage requestMessage) {
        Objects.requireNonNull(requestMessage);
        switch (requestMessage.getOperation()) {
            case "register": {
                return this.processRegisterRequest(requestMessage);
            }
            case "assert": {
                return super.processRequest(requestMessage);
            }
            case "get": {
                return this.processGetRequest(requestMessage);
            }
            case "update": {
                return this.processUpdateRequest(requestMessage);
            }
            case "deregister": {
                return this.processDeregisterRequest(requestMessage);
            }
        }
        return this.processCustomRegistrationMessage(requestMessage);
    }

    private Future<EventBusMessage> processRegisterRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        JsonObject payload = this.getRequestPayload(request.getJsonPayload());
        if (tenantId == null || deviceId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("registering device [{}] for tenant [{}]", (Object)deviceId, (Object)tenantId);
        Future result = Future.future();
        this.addDevice(tenantId, deviceId, payload, (Handler<AsyncResult<RegistrationResult>>)result.completer());
        return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setCacheDirective(res.getCacheDirective()));
    }

    private Future<EventBusMessage> processGetRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        if (tenantId == null || deviceId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("retrieving device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
        Future result = Future.future();
        this.getDevice(tenantId, deviceId, (Handler<AsyncResult<RegistrationResult>>)result.completer());
        return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
    }

    private Future<EventBusMessage> processUpdateRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        JsonObject payload = this.getRequestPayload(request.getJsonPayload());
        if (tenantId == null || deviceId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("updating registration information for device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
        Future result = Future.future();
        this.updateDevice(tenantId, deviceId, payload, (Handler<AsyncResult<RegistrationResult>>)result.completer());
        return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setCacheDirective(res.getCacheDirective()));
    }

    private Future<EventBusMessage> processDeregisterRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        if (tenantId == null || deviceId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("deregistering device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
        Future result = Future.future();
        this.removeDevice(tenantId, deviceId, (Handler<AsyncResult<RegistrationResult>>)result.completer());
        return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setCacheDirective(res.getCacheDirective()));
    }

    @Override
    public void addDevice(String tenantId, String deviceId, JsonObject otherKeys, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void updateDevice(String tenantId, String deviceId, JsonObject otherKeys, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void removeDevice(String tenantId, String deviceId, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }
}

