/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.metric;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.eclipse.hono.service.metric.Metrics;

public abstract class MicrometerBasedMetrics
implements Metrics {
    public static final String METER_CONNECTIONS_AUTHENTICATED = "hono.connections.authenticated";
    public static final String METER_CONNECTIONS_UNAUTHENTICATED = "hono.connections.unauthenticated";
    public static final String METER_MESSAGES_PROCESSED = "hono.messages.processed";
    static final String METER_COMMANDS_DEVICE_DELIVERED = "hono.commands.device.delivered";
    static final String METER_COMMANDS_RESPONSE_DELIVERED = "hono.commands.response.delivered";
    static final String METER_COMMANDS_TTD_EXPIRED = "hono.commands.ttd.expired";
    static final String METER_MESSAGES_UNDELIVERABLE = "hono.messages.undeliverable";
    protected final MeterRegistry registry;
    private final Map<String, AtomicLong> authenticatedConnections = new ConcurrentHashMap<String, AtomicLong>();
    private final AtomicLong unauthenticatedConnections;
    private final AtomicLong totalCurrentConnections = new AtomicLong();

    public MicrometerBasedMetrics(MeterRegistry registry) {
        Objects.requireNonNull(registry);
        this.registry = registry;
        this.unauthenticatedConnections = (AtomicLong)registry.gauge(METER_CONNECTIONS_UNAUTHENTICATED, (Number)new AtomicLong());
    }

    @Override
    public final void incrementConnections(String tenantId) {
        Objects.requireNonNull(tenantId);
        this.gaugeForTenant(METER_CONNECTIONS_AUTHENTICATED, this.authenticatedConnections, tenantId, AtomicLong::new).incrementAndGet();
        this.totalCurrentConnections.incrementAndGet();
    }

    @Override
    public final void decrementConnections(String tenantId) {
        Objects.requireNonNull(tenantId);
        this.gaugeForTenant(METER_CONNECTIONS_AUTHENTICATED, this.authenticatedConnections, tenantId, AtomicLong::new).decrementAndGet();
        this.totalCurrentConnections.decrementAndGet();
    }

    @Override
    public final void incrementUnauthenticatedConnections() {
        this.unauthenticatedConnections.incrementAndGet();
        this.totalCurrentConnections.incrementAndGet();
    }

    @Override
    public final void decrementUnauthenticatedConnections() {
        this.unauthenticatedConnections.decrementAndGet();
        this.totalCurrentConnections.decrementAndGet();
    }

    @Override
    public long getNumberOfConnections() {
        return this.totalCurrentConnections.get();
    }

    @Override
    public final void incrementProcessedMessages(String type, String tenantId) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(tenantId);
        this.registry.counter(METER_MESSAGES_PROCESSED, (Iterable)Tags.of((String)"tenant", (String)tenantId).and("type", type)).increment();
    }

    @Override
    public final void incrementUndeliverableMessages(String type, String tenantId) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(tenantId);
        this.registry.counter(METER_MESSAGES_UNDELIVERABLE, (Iterable)Tags.of((String)"tenant", (String)tenantId).and("type", type)).increment();
    }

    @Override
    public final void incrementProcessedPayload(String type, String tenantId, long payloadSize) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(tenantId);
        if (payloadSize < 0L) {
            return;
        }
        this.registry.counter("hono.messages.processed.payload", (Iterable)Tags.of((String)"tenant", (String)tenantId).and("type", type)).increment((double)payloadSize);
    }

    @Override
    public final void incrementCommandDeliveredToDevice(String tenantId) {
        Objects.requireNonNull(tenantId);
        this.registry.counter(METER_COMMANDS_DEVICE_DELIVERED, (Iterable)Tags.of((String)"tenant", (String)tenantId)).increment();
    }

    @Override
    public final void incrementNoCommandReceivedAndTTDExpired(String tenantId) {
        Objects.requireNonNull(tenantId);
        this.registry.counter(METER_COMMANDS_TTD_EXPIRED, (Iterable)Tags.of((String)"tenant", (String)tenantId)).increment();
    }

    @Override
    public final void incrementCommandResponseDeliveredToApplication(String tenantId) {
        Objects.requireNonNull(tenantId);
        this.registry.counter(METER_COMMANDS_RESPONSE_DELIVERED, (Iterable)Tags.of((String)"tenant", (String)tenantId)).increment();
    }

    protected <K, V extends Number> V gaugeForKey(String name, Map<K, V> map, K key, Tags tags, Supplier<V> instanceSupplier) {
        return (V)map.computeIfAbsent(key, a -> this.registry.gauge(name, (Iterable)tags, (Number)instanceSupplier.get()));
    }

    protected <V extends Number> V gaugeForTenant(String name, Map<String, V> map, String tenant, Supplier<V> instanceSupplier) {
        return this.gaugeForKey(name, map, tenant, Tags.of((String)"tenant", (String)tenant), instanceSupplier);
    }
}

