/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.metric;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.MeterFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.hono.service.metric.AbstractLegacyMetricsConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ConditionalOnProperty(name={"hono.metrics.legacy"}, havingValue="true")
@PropertySource(value={"classpath:org/eclipse/hono/service/metric/legacy.properties"})
public class LegacyMetricsConfig
extends AbstractLegacyMetricsConfig {
    @Override
    protected MeterFilter meterTypeMapper() {
        return new MeterFilter(){

            public Meter.Id map(Meter.Id id) {
                String name = id.getName();
                if (!name.startsWith("hono.")) {
                    return id;
                }
                name = name.substring("hono.".length());
                ArrayList<Tag> newTags = new ArrayList<Tag>(id.getTags());
                newTags.add(Tag.of((String)"hono", (String)"hono"));
                if ("hono.connections.authenticated".equals(id.getName()) || "hono.connections.unauthenticated".equals(id.getName())) {
                    this.mapComponentName(id, newTags);
                    newTags.add(Tag.of((String)"meterType", (String)"counter"));
                    newTags.add(Tag.of((String)"typeSuffix", (String)"count"));
                } else if ("hono.messages.undeliverable".equals(id.getName())) {
                    this.mapComponentName(id, newTags);
                    newTags.add(Tag.of((String)"meterType", (String)"counter"));
                    newTags.add(Tag.of((String)"subName", (String)name.substring("messages.".length())));
                    name = "messages";
                } else if (name.startsWith("messages.")) {
                    this.mapComponentName(id, newTags);
                    newTags.add(Tag.of((String)"meterType", (String)"meter"));
                    newTags.add(Tag.of((String)"subName", (String)name.substring("messages.".length())));
                    name = "messages";
                } else if (name.startsWith("payload.")) {
                    this.mapComponentName(id, newTags);
                    newTags.add(Tag.of((String)"meterType", (String)"meter"));
                    newTags.add(Tag.of((String)"subName", (String)name.substring("payload.".length())));
                    name = "payload";
                } else if (name.startsWith("commands.")) {
                    this.mapComponentName(id, newTags);
                    newTags.add(Tag.of((String)"meterType", (String)"meter"));
                    newTags.add(Tag.of((String)"subName", (String)name.substring("commands.".length())));
                    name = "commands";
                }
                return new Meter.Id(name, newTags, id.getBaseUnit(), id.getDescription(), id.getType());
            }

            private void mapComponentName(Meter.Id id, List<Tag> newTags) {
                String componentName = id.getTag("component-name");
                if (componentName != null) {
                    String protocol = LegacyMetricsConfig.this.getProtocolForComponentName(componentName);
                    newTags.add(Tag.of((String)"protocol", (String)protocol));
                }
            }
        };
    }
}

