/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.AbstractEndpoint;
import org.eclipse.hono.service.http.HttpEndpoint;
import org.eclipse.hono.service.http.HttpUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractHttpEndpoint<T>
extends AbstractEndpoint
implements HttpEndpoint {
    protected static final String KEY_REQUEST_BODY = "KEY_REQUEST_BODY";
    protected static final String PARAM_TENANT_ID = "tenant_id";
    protected static final String PARAM_DEVICE_ID = "device_id";
    protected T config;

    public AbstractHttpEndpoint(Vertx vertx) {
        super(vertx);
    }

    @Qualifier(value="rest")
    @Autowired(required=false)
    public final void setConfiguration(T props) {
        this.config = Objects.requireNonNull(props);
    }

    protected abstract String getEventBusAddress();

    protected void extractRequiredJsonPayload(RoutingContext ctx) {
        MIMEHeader contentType = ctx.parsedHeaders().contentType();
        if (contentType == null) {
            ctx.fail((Throwable)new ClientErrorException(400, "Missing Content-Type header"));
        } else if (!"application/json".equalsIgnoreCase(contentType.value())) {
            ctx.fail((Throwable)new ClientErrorException(400, "Unsupported Content-Type"));
        } else {
            try {
                if (ctx.getBody() != null) {
                    ctx.put(KEY_REQUEST_BODY, (Object)ctx.getBodyAsJson());
                    ctx.next();
                } else {
                    ctx.fail((Throwable)new ClientErrorException(400, "Empty body"));
                }
            }
            catch (DecodeException e) {
                ctx.fail((Throwable)new ClientErrorException(400, "Invalid JSON"));
            }
        }
    }

    protected final BiConsumer<Integer, JsonObject> getDefaultResponseHandler(RoutingContext ctx) {
        return this.getDefaultResponseHandler(ctx, status -> false, null);
    }

    protected final BiConsumer<Integer, JsonObject> getDefaultResponseHandler(RoutingContext ctx, Predicate<Integer> successfulOutcomeFilter, Handler<HttpServerResponse> customHandler) {
        Objects.requireNonNull(successfulOutcomeFilter);
        HttpServerResponse response = ctx.response();
        return (status, jsonResult) -> {
            response.setStatusCode(status.intValue());
            if (status >= 400) {
                HttpUtils.setResponseBody(response, jsonResult);
            } else if (successfulOutcomeFilter.test((Integer)status)) {
                HttpUtils.setResponseBody(response, jsonResult);
                if (customHandler != null) {
                    customHandler.handle((Object)response);
                }
            }
            response.end();
        };
    }

    protected final void sendAction(RoutingContext ctx, JsonObject requestMsg, BiConsumer<Integer, JsonObject> responseHandler) {
        this.vertx.eventBus().send(this.getEventBusAddress(), (Object)requestMsg, invocation -> {
            if (invocation.failed()) {
                HttpUtils.serviceUnavailable(ctx, 2);
            } else {
                JsonObject jsonResult = (JsonObject)((Message)invocation.result()).body();
                Integer status = jsonResult.getInteger("status");
                JsonObject payload = jsonResult.getJsonObject("payload");
                responseHandler.accept(status, payload);
            }
        });
    }

    protected final String getTenantParam(RoutingContext ctx) {
        return ctx.request().getParam(PARAM_TENANT_ID);
    }

    protected final String getDeviceIdParam(RoutingContext ctx) {
        return ctx.request().getParam(PARAM_DEVICE_ID);
    }
}

