/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.credentials;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.Objects;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.http.AbstractHttpEndpoint;
import org.eclipse.hono.util.CredentialsConstants;
import org.eclipse.hono.util.EventBusMessage;
import org.springframework.beans.factory.annotation.Autowired;

public final class CredentialsHttpEndpoint
extends AbstractHttpEndpoint<ServiceConfigProperties> {
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_AUTH_ID = "auth_id";

    @Autowired
    public CredentialsHttpEndpoint(Vertx vertx) {
        super(Objects.requireNonNull(vertx));
    }

    @Override
    protected String getEventBusAddress() {
        return "credentials.in";
    }

    @Override
    public void addRoutes(Router router) {
        String pathWithTenant = String.format("/%s/:%s", "credentials", "tenant_id");
        String pathWithTenantAndDeviceId = String.format("/%s/:%s/:%s", "credentials", "tenant_id", "device_id");
        String pathWithTenantAndAuthIdAndType = String.format("/%s/:%s/:%s/:%s", "credentials", "tenant_id", PARAM_AUTH_ID, PARAM_TYPE);
        BodyHandler bodyHandler = BodyHandler.create();
        bodyHandler.setBodyLimit((long)((ServiceConfigProperties)this.config).getMaxPayloadSize());
        router.post(pathWithTenant).handler((Handler)bodyHandler);
        router.post(pathWithTenant).handler(this::extractRequiredJsonPayload);
        router.post(pathWithTenant).handler(this::addCredentials);
        router.get(pathWithTenantAndAuthIdAndType).handler(this::getCredentials);
        router.get(pathWithTenantAndDeviceId).handler(this::getCredentialsForDevice);
        router.put(pathWithTenantAndAuthIdAndType).handler((Handler)bodyHandler);
        router.put(pathWithTenantAndAuthIdAndType).handler(this::extractRequiredJsonPayload);
        router.put(pathWithTenantAndAuthIdAndType).handler(this::updateCredentials);
        router.delete(pathWithTenantAndAuthIdAndType).handler(this::removeCredentials);
        router.delete(pathWithTenantAndDeviceId).handler(this::removeCredentialsForDevice);
    }

    private static String getTypeParam(RoutingContext ctx) {
        return ctx.request().getParam(PARAM_TYPE);
    }

    private static String getAuthIdParam(RoutingContext ctx) {
        return ctx.request().getParam(PARAM_AUTH_ID);
    }

    @Override
    public String getName() {
        return "credentials";
    }

    private void addCredentials(RoutingContext ctx) {
        JsonObject payload = (JsonObject)ctx.get("KEY_REQUEST_BODY");
        String deviceId = payload.getString("device-id");
        String authId = payload.getString("auth-id");
        String type = payload.getString(PARAM_TYPE);
        String tenantId = this.getTenantParam(ctx);
        this.logger.debug("adding credentials [tenant: {}, device-id: {}, auth-id: {}, type: {}]", new Object[]{tenantId, deviceId, authId, type});
        JsonObject requestMsg = EventBusMessage.forOperation((String)CredentialsConstants.CredentialsAction.add.toString()).setTenant(tenantId).setDeviceId(deviceId).setJsonPayload(payload).toJson();
        this.sendAction(ctx, requestMsg, this.getDefaultResponseHandler(ctx, status -> status == 201, (Handler<HttpServerResponse>)((Handler)httpServerResponse -> httpServerResponse.putHeader(HttpHeaders.LOCATION, (CharSequence)String.format("/%s/%s/%s/%s", "credentials", tenantId, authId, type)))));
    }

    private void updateCredentials(RoutingContext ctx) {
        JsonObject payload = (JsonObject)ctx.get("KEY_REQUEST_BODY");
        String deviceId = payload.getString("device-id");
        String authId = payload.getString("auth-id");
        String type = payload.getString(PARAM_TYPE);
        String tenantId = this.getTenantParam(ctx);
        String authIdFromUri = CredentialsHttpEndpoint.getAuthIdParam(ctx);
        String typeFromUri = CredentialsHttpEndpoint.getTypeParam(ctx);
        if (!authIdFromUri.equals(authId)) {
            ctx.fail((Throwable)new ClientErrorException(400, "Non-matching authentication identifier"));
        } else if (!typeFromUri.equals(type)) {
            ctx.fail((Throwable)new ClientErrorException(400, "Non-matching credentials type"));
        } else {
            this.logger.debug("updating credentials [tenant: {}, device-id: {}, auth-id: {}, type: {}]", new Object[]{tenantId, deviceId, authId, type});
            JsonObject requestMsg = EventBusMessage.forOperation((String)CredentialsConstants.CredentialsAction.update.toString()).setTenant(tenantId).setDeviceId(deviceId).setJsonPayload(payload).toJson();
            this.sendAction(ctx, requestMsg, this.getDefaultResponseHandler(ctx));
        }
    }

    private void removeCredentials(RoutingContext ctx) {
        String tenantId = this.getTenantParam(ctx);
        String type = CredentialsHttpEndpoint.getTypeParam(ctx);
        String authId = CredentialsHttpEndpoint.getAuthIdParam(ctx);
        this.logger.debug("removeCredentials [tenant: {}, type: {}, authId: {}]", new Object[]{tenantId, type, authId});
        JsonObject payload = new JsonObject();
        payload.put(PARAM_TYPE, type);
        payload.put("auth-id", authId);
        JsonObject requestMsg = EventBusMessage.forOperation((String)CredentialsConstants.CredentialsAction.remove.toString()).setTenant(tenantId).setJsonPayload(payload).toJson();
        this.sendAction(ctx, requestMsg, this.getDefaultResponseHandler(ctx, status -> status == 204, null));
    }

    private void removeCredentialsForDevice(RoutingContext ctx) {
        String tenantId = this.getTenantParam(ctx);
        String deviceId = this.getDeviceIdParam(ctx);
        this.logger.debug("removeCredentialsForDevice: [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
        JsonObject payload = new JsonObject();
        payload.put("device-id", deviceId);
        payload.put(PARAM_TYPE, "*");
        JsonObject requestMsg = EventBusMessage.forOperation((String)CredentialsConstants.CredentialsAction.remove.toString()).setTenant(tenantId).setDeviceId(deviceId).setJsonPayload(payload).toJson();
        this.sendAction(ctx, requestMsg, this.getDefaultResponseHandler(ctx, status -> status == 204, null));
    }

    private void getCredentials(RoutingContext ctx) {
        String tenantId = this.getTenantParam(ctx);
        String authId = CredentialsHttpEndpoint.getAuthIdParam(ctx);
        String type = CredentialsHttpEndpoint.getTypeParam(ctx);
        this.logger.debug("getCredentials [tenant: {}, auth-id: {}, type: {}]", new Object[]{tenantId, authId, type});
        JsonObject requestMsg = CredentialsConstants.getServiceGetRequestAsJson((String)tenantId, null, (String)authId, (String)type);
        this.sendAction(ctx, requestMsg, this.getDefaultResponseHandler(ctx, status -> status == 200, null));
    }

    private void getCredentialsForDevice(RoutingContext ctx) {
        String tenantId = this.getTenantParam(ctx);
        String deviceId = this.getDeviceIdParam(ctx);
        this.logger.debug("getCredentialsForDevice [tenant: {}, device-id: {}]]", (Object)tenantId, (Object)deviceId);
        JsonObject requestMsg = CredentialsConstants.getServiceGetRequestAsJson((String)tenantId, (String)deviceId, null, (String)"*");
        this.sendAction(ctx, requestMsg, this.getDefaultResponseHandler(ctx, status -> status == 200, null));
    }
}

