/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.credentials;

import io.opentracing.Span;
import io.opentracing.noop.NoopSpan;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.auth.BCryptHelper;
import org.eclipse.hono.auth.HonoPasswordEncoder;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.credentials.BaseCredentialsService;
import org.eclipse.hono.service.credentials.CompleteCredentialsService;
import org.eclipse.hono.util.CredentialsConstants;
import org.eclipse.hono.util.CredentialsObject;
import org.eclipse.hono.util.CredentialsResult;
import org.eclipse.hono.util.EventBusMessage;

public abstract class CompleteBaseCredentialsService<T>
extends BaseCredentialsService<T>
implements CompleteCredentialsService {
    private static final int DEFAULT_MAX_BCRYPT_ITERATIONS = 10;
    private HonoPasswordEncoder pwdEncoder;

    protected CompleteBaseCredentialsService(HonoPasswordEncoder pwdEncoder) {
        this.pwdEncoder = Objects.requireNonNull(pwdEncoder);
    }

    @Override
    public final Future<EventBusMessage> processRequest(EventBusMessage request) {
        Objects.requireNonNull(request);
        String operation = request.getOperation();
        switch (CredentialsConstants.CredentialsAction.from((String)operation)) {
            case get: {
                return this.processGetRequest(request);
            }
            case add: {
                return this.processAddRequest(request);
            }
            case update: {
                return this.processUpdateRequest(request);
            }
            case remove: {
                return this.processRemoveRequest(request);
            }
        }
        return this.processCustomCredentialsMessage(request);
    }

    private Future<EventBusMessage> processAddRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        CredentialsObject payload = Optional.ofNullable(request.getJsonPayload()).map(json -> (CredentialsObject)json.mapTo(CredentialsObject.class)).orElse(null);
        if (tenantId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, "missing tenant ID"));
        }
        if (payload == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, "missing payload"));
        }
        return this.hashPlainPasswords(payload).compose(credentials -> this.doAdd(request, tenantId, (CredentialsObject)credentials));
    }

    private Future<EventBusMessage> doAdd(EventBusMessage request, String tenantId, CredentialsObject payload) {
        try {
            payload.checkValidity(this::checkSecret);
            Future result = Future.future();
            this.add(tenantId, JsonObject.mapFrom((Object)payload), (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result.completer());
            return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(payload.getDeviceId()).setCacheDirective(res.getCacheDirective()));
        }
        catch (IllegalStateException e) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, e.getMessage()));
        }
    }

    private Future<EventBusMessage> processUpdateRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        CredentialsObject payload = Optional.ofNullable(request.getJsonPayload()).map(json -> (CredentialsObject)json.mapTo(CredentialsObject.class)).orElse(null);
        if (tenantId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, "missing tenant ID"));
        }
        if (payload == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, "missing payload"));
        }
        return this.hashPlainPasswords(payload).compose(credentials -> this.doUpdate(request, tenantId, (CredentialsObject)credentials));
    }

    private Future<EventBusMessage> doUpdate(EventBusMessage request, String tenantId, CredentialsObject payload) {
        try {
            payload.checkValidity(this::checkSecret);
            Future result = Future.future();
            this.update(tenantId, JsonObject.mapFrom((Object)payload), (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result.completer());
            return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(payload.getDeviceId()).setCacheDirective(res.getCacheDirective()));
        }
        catch (IllegalStateException e) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, e.getMessage()));
        }
    }

    private Future<EventBusMessage> processRemoveRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        JsonObject payload = request.getJsonPayload();
        if (tenantId == null || payload == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        String type = CompleteBaseCredentialsService.getTypesafeValueForField(String.class, payload, "type");
        String authId = CompleteBaseCredentialsService.getTypesafeValueForField(String.class, payload, "auth-id");
        String deviceId = CompleteBaseCredentialsService.getTypesafeValueForField(String.class, payload, "device-id");
        if (type == null) {
            this.log.debug("remove credentials request does not contain mandatory type parameter");
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (!type.equals("*") && authId != null) {
            this.log.debug("removing specific credentials [tenant: {}, type: {}, auth-id: {}]", new Object[]{tenantId, type, authId});
            Future result = Future.future();
            this.remove(tenantId, type, authId, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result.completer());
            return result.map(res -> request.getResponse(res.getStatus()).setCacheDirective(res.getCacheDirective()));
        }
        if (deviceId != null && type.equals("*")) {
            this.log.debug("removing all credentials for device [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
            Future result = Future.future();
            this.removeAll(tenantId, deviceId, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result.completer());
            return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setCacheDirective(res.getCacheDirective()));
        }
        this.log.debug("remove credentials request contains invalid search criteria [type: {}, device-id: {}, auth-id: {}]", new Object[]{type, deviceId, authId});
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    @Override
    public final void getAll(String tenantId, String deviceId, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.getAll(tenantId, deviceId, (Span)NoopSpan.INSTANCE, resultHandler);
    }

    @Override
    public void add(String tenantId, JsonObject otherKeys, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void update(String tenantId, JsonObject otherKeys, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void remove(String tenantId, String type, String authId, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void removeAll(String tenantId, String deviceId, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    private void checkSecret(String type, JsonObject secret) {
        block3 : switch (type) {
            case "hashed-password": {
                switch (CredentialsConstants.getHashFunction((JsonObject)secret)) {
                    case "bcrypt": {
                        String pwdHash = CredentialsConstants.getPasswordHash((JsonObject)secret);
                        this.verifyBcryptPasswordHash(pwdHash);
                        break block3;
                    }
                }
            }
        }
    }

    protected int getMaxBcryptIterations() {
        return 10;
    }

    protected final Future<CredentialsObject> hashPlainPasswords(CredentialsObject credentials) {
        Future result = Future.future();
        if ("hashed-password".equals(credentials.getType())) {
            this.getVertx().executeBlocking(blockingCodeHandler -> {
                this.log.debug("hashing password on vert.x worker thread [{}]", (Object)Thread.currentThread().getName());
                credentials.getSecrets().forEach(secret -> this.hashPwdAndUpdateSecret((JsonObject)secret));
                blockingCodeHandler.complete((Object)credentials);
            }, (Handler)result);
        } else {
            result.complete((Object)credentials);
        }
        return result;
    }

    private JsonObject hashPwdAndUpdateSecret(JsonObject secret) {
        String pwd = Optional.ofNullable(secret.remove("pwd-plain")).map(o -> {
            if (o instanceof String) {
                return (String)o;
            }
            return "";
        }).orElse("");
        if (pwd.isEmpty()) {
            return secret;
        }
        JsonObject encodedPwd = this.pwdEncoder.encode(pwd);
        secret.mergeIn(encodedPwd);
        return secret;
    }

    protected void verifyBcryptPasswordHash(String pwdHash) {
        Objects.requireNonNull(pwdHash);
        if (BCryptHelper.getIterations((String)pwdHash) > this.getMaxBcryptIterations()) {
            throw new IllegalStateException("password hash uses too many iterations, max is " + this.getMaxBcryptIterations());
        }
    }
}

