/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.web.Router;
import java.util.Objects;
import org.eclipse.hono.config.ApplicationConfigProperties;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.HealthCheckServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VertxBasedHealthCheckServer
implements HealthCheckServer {
    private static final Logger LOG = LoggerFactory.getLogger(VertxBasedHealthCheckServer.class);
    private static final String URI_LIVENESS_PROBE = "/liveness";
    private static final String URI_READINESS_PROBE = "/readiness";
    private HttpServer server;
    private final HealthCheckHandler readinessHandler;
    private final HealthCheckHandler livenessHandler;
    private final Vertx vertx;
    private final ApplicationConfigProperties config;
    private Router router;

    public VertxBasedHealthCheckServer(Vertx vertx, ApplicationConfigProperties config) {
        this.vertx = Objects.requireNonNull(vertx);
        this.config = Objects.requireNonNull(config);
        if (config.getHealthCheckPort() == -1) {
            throw new IllegalArgumentException("Health check port not configured");
        }
        this.readinessHandler = HealthCheckHandler.create((Vertx)this.vertx);
        this.livenessHandler = HealthCheckHandler.create((Vertx)this.vertx);
        this.router = Router.router((Vertx)this.vertx);
    }

    @Override
    public void registerHealthCheckResources(HealthCheckProvider serviceInstance) {
        serviceInstance.registerLivenessChecks(this.livenessHandler);
        serviceInstance.registerReadinessChecks(this.readinessHandler);
    }

    @Override
    public Future<Void> start() {
        Future result = Future.future();
        HttpServerOptions options = new HttpServerOptions().setPort(this.config.getHealthCheckPort()).setHost(this.config.getHealthCheckBindAddress());
        this.server = this.vertx.createHttpServer(options);
        this.router.get(URI_READINESS_PROBE).handler((Handler)this.readinessHandler);
        this.router.get(URI_LIVENESS_PROBE).handler((Handler)this.livenessHandler);
        this.server.requestHandler((Handler)this.router).listen(startAttempt -> {
            if (startAttempt.succeeded()) {
                LOG.info("readiness probe available at http://{}:{}{}", new Object[]{options.getHost(), options.getPort(), URI_READINESS_PROBE});
                LOG.info("liveness probe available at http://{}:{}{}", new Object[]{options.getHost(), options.getPort(), URI_LIVENESS_PROBE});
                result.complete();
            } else {
                LOG.warn("failed to start health checks HTTP server: {}", (Object)startAttempt.cause().getMessage());
                result.fail(startAttempt.cause());
            }
        });
        return result;
    }

    @Override
    public Future<Void> stop() {
        Future result = Future.future();
        if (this.server != null) {
            LOG.info("closing health check HTTP server [{}:{}]", (Object)this.config.getHealthCheckBindAddress(), (Object)this.server.actualPort());
            this.server.close(result.completer());
        } else {
            result.complete();
        }
        return result;
    }
}

