/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.netty.handler.ssl.OpenSsl;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import io.vertx.core.Future;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import java.util.Objects;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.HealthCheckServer;
import org.eclipse.hono.service.NoopHealthCheckServer;
import org.eclipse.hono.util.ConfigurationSupportingVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractServiceBase<T extends ServiceConfigProperties>
extends ConfigurationSupportingVerticle<T>
implements HealthCheckProvider {
    private HealthCheckServer healthCheckServer = new NoopHealthCheckServer();
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected Tracer tracer = NoopTracerFactory.create();

    @Autowired(required=false)
    public final void setTracer(Tracer opentracingTracer) {
        this.LOG.info("using OpenTracing Tracer implementation [{}]", (Object)opentracingTracer.getClass().getName());
        this.tracer = Objects.requireNonNull(opentracingTracer);
    }

    @Autowired(required=false)
    public void setHealthCheckServer(HealthCheckServer healthCheckServer) {
        this.healthCheckServer = Objects.requireNonNull(healthCheckServer);
    }

    public final void start(Future<Void> startFuture) {
        this.healthCheckServer.registerHealthCheckResources(this);
        this.startInternal().setHandler(startFuture.completer());
    }

    protected Future<Void> startInternal() {
        return Future.succeededFuture();
    }

    public final void stop(Future<Void> stopFuture) {
        this.stopInternal().setHandler(stopFuture.completer());
    }

    protected Future<Void> stopInternal() {
        return Future.succeededFuture();
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler handler) {
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler handler) {
    }

    public abstract int getPortDefaultValue();

    public abstract int getInsecurePortDefaultValue();

    protected abstract int getActualPort();

    protected abstract int getActualInsecurePort();

    public final int getPort() {
        if (this.getActualPort() != -1) {
            return this.getActualPort();
        }
        if (this.isSecurePortEnabled()) {
            return ((ServiceConfigProperties)this.getConfig()).getPort(this.getPortDefaultValue());
        }
        return -1;
    }

    public final int getInsecurePort() {
        if (this.getActualInsecurePort() != -1) {
            return this.getActualInsecurePort();
        }
        if (this.isInsecurePortEnabled()) {
            return ((ServiceConfigProperties)this.getConfig()).getInsecurePort(this.getInsecurePortDefaultValue());
        }
        return -1;
    }

    protected final Future<Void> checkPortConfiguration() {
        if (this.vertx != null) {
            this.LOG.info("Vertx native support: {}", (Object)this.vertx.isNativeTransportEnabled());
        }
        Future result = Future.future();
        if (((ServiceConfigProperties)this.getConfig()).getKeyCertOptions() == null) {
            if (((ServiceConfigProperties)this.getConfig()).getPort() >= 0) {
                this.LOG.warn("Secure port number configured, but the certificate setup is not correct. No secure port will be opened - please check your configuration!");
            }
            if (!((ServiceConfigProperties)this.getConfig()).isInsecurePortEnabled()) {
                this.LOG.error("configuration must have at least one of key & certificate or insecure port set to start up");
                result.fail("no ports configured");
            } else {
                result.complete();
            }
        } else if (((ServiceConfigProperties)this.getConfig()).isInsecurePortEnabled()) {
            if (((ServiceConfigProperties)this.getConfig()).getPort(this.getPortDefaultValue()) == ((ServiceConfigProperties)this.getConfig()).getInsecurePort(this.getInsecurePortDefaultValue())) {
                this.LOG.error("secure and insecure ports must be configured to bind to different port numbers");
                result.fail("secure and insecure ports configured to bind to same port number");
            } else {
                result.complete();
            }
        } else {
            result.complete();
        }
        return result;
    }

    protected final int determineSecurePort() {
        int port = ((ServiceConfigProperties)this.getConfig()).getPort(this.getPortDefaultValue());
        if (port == this.getPortDefaultValue()) {
            this.LOG.info("Server uses secure standard port {}", (Object)port);
        } else if (port == 0) {
            this.LOG.info("Server found secure port number configured for ephemeral port selection (port chosen automatically).");
        }
        return port;
    }

    protected final int determineInsecurePort() {
        int insecurePort = ((ServiceConfigProperties)this.getConfig()).getInsecurePort(this.getInsecurePortDefaultValue());
        if (insecurePort == 0) {
            this.LOG.info("Server found insecure port number configured for ephemeral port selection (port chosen automatically).");
        } else if (insecurePort == this.getInsecurePortDefaultValue()) {
            this.LOG.info("Server uses standard insecure port {}", (Object)insecurePort);
        } else if (insecurePort == this.getPortDefaultValue()) {
            this.LOG.warn("Server found insecure port number configured to standard port for secure connections {}", (Object)((ServiceConfigProperties)this.getConfig()).getInsecurePort());
            this.LOG.warn("Possibly misconfigured?");
        }
        return insecurePort;
    }

    protected boolean isSecurePortEnabled() {
        return ((ServiceConfigProperties)this.getConfig()).getKeyCertOptions() != null;
    }

    protected boolean isInsecurePortEnabled() {
        return ((ServiceConfigProperties)this.getConfig()).isInsecurePortEnabled();
    }

    public final String getBindAddress() {
        return ((ServiceConfigProperties)this.getConfig()).getBindAddress();
    }

    public final String getInsecurePortBindAddress() {
        return ((ServiceConfigProperties)this.getConfig()).getInsecurePortBindAddress();
    }

    protected final void addTlsTrustOptions(NetServerOptions serverOptions) {
        TrustOptions trustOptions;
        if (serverOptions.isSsl() && serverOptions.getTrustOptions() == null && (trustOptions = this.getServerTrustOptions()) != null) {
            serverOptions.setTrustOptions(trustOptions).setClientAuth(ClientAuth.REQUEST);
            this.LOG.info("enabling client authentication using certificates [{}]", (Object)trustOptions.getClass().getName());
        }
    }

    protected TrustOptions getServerTrustOptions() {
        return ((ServiceConfigProperties)this.getConfig()).getTrustOptions();
    }

    protected final void addTlsKeyCertOptions(NetServerOptions serverOptions) {
        KeyCertOptions keyCertOptions = ((ServiceConfigProperties)this.getConfig()).getKeyCertOptions();
        if (keyCertOptions != null) {
            serverOptions.setSsl(true).setKeyCertOptions(keyCertOptions);
        }
        if (serverOptions.isSsl()) {
            boolean isOpenSslAvailable = OpenSsl.isAvailable();
            boolean supportsKeyManagerFactory = OpenSsl.supportsKeyManagerFactory();
            boolean useOpenSsl = ((ServiceConfigProperties)this.getConfig()).isNativeTlsRequired() || isOpenSslAvailable && supportsKeyManagerFactory;
            this.LOG.debug("OpenSSL [available: {}, supports KeyManagerFactory: {}]", (Object)isOpenSslAvailable, (Object)supportsKeyManagerFactory);
            if (useOpenSsl) {
                this.LOG.info("using OpenSSL [version: {}] instead of JDK's default SSL engine", (Object)OpenSsl.versionString());
                serverOptions.setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions());
            } else {
                this.LOG.info("using JDK's default SSL engine");
            }
            serverOptions.getEnabledSecureTransportProtocols().forEach(protocol -> serverOptions.removeEnabledSecureTransportProtocol(protocol));
            ((ServiceConfigProperties)this.getConfig()).getSecureProtocols().forEach(protocol -> {
                this.LOG.info("enabling secure protocol [{}]", protocol);
                serverOptions.addEnabledSecureTransportProtocol(protocol);
            });
        }
    }
}

