/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tenant;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.tenant.TenantService;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.TenantConstants;
import org.eclipse.hono.util.TenantResult;

public abstract class BaseTenantService<T>
extends EventBusService<T>
implements TenantService {
    @Override
    protected final String getEventBusAddress() {
        return "tenant.in";
    }

    @Override
    public Future<EventBusMessage> processRequest(EventBusMessage request) {
        Objects.requireNonNull(request);
        switch (TenantConstants.TenantAction.from((String)request.getOperation())) {
            case get: {
                return this.processGetRequest(request);
            }
        }
        return this.processCustomTenantMessage(request);
    }

    Future<EventBusMessage> processGetRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        JsonObject payload = request.getJsonPayload();
        if (tenantId == null && payload == null) {
            this.log.debug("request does not contain any query parameters");
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (tenantId != null) {
            this.log.debug("retrieving tenant [{}] using deprecated variant of get tenant request", (Object)tenantId);
            return this.processGetByIdRequest(request, tenantId);
        }
        String tenantIdFromPayload = BaseTenantService.getTypesafeValueForField(String.class, payload, "tenant-id");
        String subjectDn = BaseTenantService.getTypesafeValueForField(String.class, payload, "subject-dn");
        if (tenantIdFromPayload == null && subjectDn == null) {
            this.log.debug("payload does not contain any query parameters");
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (tenantIdFromPayload != null) {
            this.log.debug("retrieving tenant [id: {}]", (Object)tenantIdFromPayload);
            return this.processGetByIdRequest(request, tenantIdFromPayload);
        }
        return this.processGetByCaRequest(request, subjectDn);
    }

    private Future<EventBusMessage> processGetByIdRequest(EventBusMessage request, String tenantId) {
        Future getResult = Future.future();
        this.get(tenantId, (Handler<AsyncResult<TenantResult<JsonObject>>>)getResult.completer());
        return getResult.map(tr -> request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setTenant(tenantId).setCacheDirective(tr.getCacheDirective()));
    }

    private Future<EventBusMessage> processGetByCaRequest(EventBusMessage request, String subjectDn) {
        try {
            X500Principal dn = new X500Principal(subjectDn);
            this.log.debug("retrieving tenant [subject DN: {}]", (Object)subjectDn);
            Future getResult = Future.future();
            this.get(dn, (Handler<AsyncResult<TenantResult<JsonObject>>>)getResult.completer());
            return getResult.map(tr -> {
                EventBusMessage response = request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setCacheDirective(tr.getCacheDirective());
                if (tr.isOk() && tr.getPayload() != null) {
                    response.setTenant(BaseTenantService.getTypesafeValueForField(String.class, (JsonObject)tr.getPayload(), "tenant-id"));
                }
                return response;
            });
        }
        catch (IllegalArgumentException e) {
            this.log.debug("cannot parse subject DN [{}] provided by client", (Object)subjectDn);
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
    }

    protected Future<EventBusMessage> processCustomTenantMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    @Override
    public void get(String tenantId, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void get(X500Principal subjectDn, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    protected void handleUnimplementedOperation(Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        resultHandler.handle((Object)Future.failedFuture((Throwable)new ServerErrorException(501)));
    }
}

