/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.HttpStatusException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.service.http.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFailureHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFailureHandler.class);

    public void handle(RoutingContext ctx) {
        if (ctx.failed()) {
            if (ctx.response().ended()) {
                LOG.debug("skipping processing of failed route, response already ended");
            } else {
                LOG.debug("handling failed route for request [method: {}, URI: {}]", (Object)ctx.request().method(), (Object)ctx.request().absoluteURI());
                if (ctx.failure() != null) {
                    if (ctx.failure() instanceof ServiceInvocationException) {
                        ServiceInvocationException e = (ServiceInvocationException)ctx.failure();
                        this.sendError(ctx.response(), e.getErrorCode(), e.getMessage());
                    } else if (ctx.failure() instanceof HttpStatusException) {
                        HttpStatusException e = (HttpStatusException)ctx.failure();
                        this.sendError(ctx.response(), e.getStatusCode(), e.getMessage());
                    } else {
                        this.sendError(ctx.response(), 500, ctx.failure().getMessage());
                    }
                } else if (ctx.statusCode() != -1) {
                    this.sendError(ctx.response(), ctx.statusCode(), ctx.response().getStatusMessage());
                } else {
                    this.sendError(ctx.response(), 500, "Internal Server Error");
                }
            }
        } else {
            LOG.debug("skipping processing of non-failed route");
            ctx.next();
        }
    }

    private void sendError(HttpServerResponse response, int errorCode, String errorMessage) {
        response.setStatusCode(errorCode);
        if (errorMessage != null) {
            HttpUtils.setResponseBody(response, Buffer.buffer((String)errorMessage), "text/plain; charset=utf-8");
        }
        response.end();
    }
}

