/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.credentials;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.credentials.CredentialsService;
import org.eclipse.hono.util.CredentialsConstants;
import org.eclipse.hono.util.CredentialsResult;
import org.eclipse.hono.util.EventBusMessage;

public abstract class BaseCredentialsService<T>
extends EventBusService<T>
implements CredentialsService {
    @Override
    protected String getEventBusAddress() {
        return "credentials.in";
    }

    @Override
    public Future<EventBusMessage> processRequest(EventBusMessage request) {
        Objects.requireNonNull(request);
        String operation = request.getOperation();
        switch (CredentialsConstants.CredentialsAction.from((String)operation)) {
            case get: {
                return this.processGetRequest(request);
            }
        }
        return this.processCustomCredentialsMessage(request);
    }

    protected Future<EventBusMessage> processGetRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        JsonObject payload = request.getJsonPayload();
        if (tenantId == null || payload == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        String type = BaseCredentialsService.removeTypesafeValueForField(String.class, payload, "type");
        String authId = BaseCredentialsService.removeTypesafeValueForField(String.class, payload, "auth-id");
        String deviceId = BaseCredentialsService.removeTypesafeValueForField(String.class, payload, "device-id");
        if (type == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (authId != null && deviceId == null) {
            this.log.debug("getting credentials [tenant: {}, type: {}, auth-id: {}]", new Object[]{tenantId, type, authId});
            Future result = Future.future();
            this.get(tenantId, type, authId, payload, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result.completer());
            return result.map(res -> {
                String deviceIdFromPayload = Optional.ofNullable((JsonObject)res.getPayload()).map(p -> BaseCredentialsService.getTypesafeValueForField(String.class, p, "device-id")).orElse(null);
                return request.getResponse(res.getStatus()).setDeviceId(deviceIdFromPayload).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective());
            });
        }
        if (deviceId != null && authId == null) {
            this.log.debug("getting credentials for device [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
            Future result = Future.future();
            this.getAll(tenantId, deviceId, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result.completer());
            return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
        }
        this.log.debug("get credentials request contains invalid search criteria [type: {}, device-id: {}, auth-id: {}]", new Object[]{type, deviceId, authId});
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    protected Future<EventBusMessage> processCustomCredentialsMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    @Override
    public void get(String tenantId, String type, String authId, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void get(String tenantId, String type, String authId, JsonObject clientContext, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    public abstract void getAll(String var1, String var2, Handler<AsyncResult<CredentialsResult<JsonObject>>> var3);

    protected void handleUnimplementedOperation(Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)CredentialsResult.from((int)501)));
    }
}

