/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.auth.device.CredentialsApiAuthProvider;
import org.eclipse.hono.service.auth.device.DeviceCredentials;
import org.eclipse.hono.service.auth.device.UsernamePasswordCredentials;
import org.eclipse.hono.util.CredentialsObject;
import org.springframework.beans.factory.annotation.Autowired;

public final class UsernamePasswordAuthProvider
extends CredentialsApiAuthProvider {
    private final ServiceConfigProperties config;

    @Autowired
    public UsernamePasswordAuthProvider(HonoClient credentialsServiceClient, ServiceConfigProperties config) {
        super(credentialsServiceClient);
        this.config = Objects.requireNonNull(config);
    }

    @Override
    protected DeviceCredentials getCredentials(JsonObject authInfo) {
        try {
            String username = authInfo.getString("username");
            String password = authInfo.getString("password");
            if (username == null || password == null) {
                return null;
            }
            return UsernamePasswordCredentials.create(username, password, this.config.isSingleTenant());
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    protected Future<Device> validateCredentials(DeviceCredentials deviceCredentials, CredentialsObject credentialsOnRecord) {
        Context currentContext = Vertx.currentContext();
        if (currentContext == null) {
            return Future.failedFuture((Throwable)new IllegalStateException("not running on vert.x Context"));
        }
        Future resultHandler = Future.future();
        currentContext.executeBlocking(blockingCodeHandler -> {
            this.log.debug("validating password hash on vert.x worker thread [{}]", (Object)Thread.currentThread().getName());
            if (deviceCredentials.validate(credentialsOnRecord)) {
                blockingCodeHandler.complete((Object)new Device(deviceCredentials.getTenantId(), credentialsOnRecord.getDeviceId()));
            } else {
                blockingCodeHandler.fail((Throwable)new ClientErrorException(401, "bad credentials"));
            }
        }, false, (Handler)resultHandler);
        return resultHandler;
    }
}

