/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import java.util.Objects;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.CredentialsClient;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.service.auth.DeviceUser;
import org.eclipse.hono.service.auth.device.DeviceCredentials;
import org.eclipse.hono.service.auth.device.HonoClientBasedAuthProvider;
import org.eclipse.hono.util.CredentialsObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CredentialsApiAuthProvider
implements HonoClientBasedAuthProvider {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final HonoClient credentialsServiceClient;

    public CredentialsApiAuthProvider(HonoClient credentialsServiceClient) {
        this.credentialsServiceClient = Objects.requireNonNull(credentialsServiceClient);
    }

    protected final Future<CredentialsClient> getCredentialsClient(String tenantId) {
        if (this.credentialsServiceClient == null) {
            return Future.failedFuture((Throwable)new IllegalStateException("no credentials client set"));
        }
        return this.credentialsServiceClient.getOrCreateCredentialsClient(tenantId);
    }

    protected final Future<CredentialsObject> getCredentialsForDevice(DeviceCredentials deviceCredentials) {
        Objects.requireNonNull(deviceCredentials);
        if (this.credentialsServiceClient == null) {
            return Future.failedFuture((Throwable)new IllegalStateException("Credentials API client is not set"));
        }
        return this.getCredentialsClient(deviceCredentials.getTenantId()).compose(client -> client.get(deviceCredentials.getType(), deviceCredentials.getAuthId()));
    }

    @Override
    public final void authenticate(DeviceCredentials deviceCredentials, Handler<AsyncResult<DeviceUser>> resultHandler) {
        Objects.requireNonNull(deviceCredentials);
        Objects.requireNonNull(resultHandler);
        this.getCredentialsForDevice(deviceCredentials).recover(t -> {
            if (!(t instanceof ServiceInvocationException)) {
                return Future.failedFuture((Throwable)t);
            }
            ServiceInvocationException e = (ServiceInvocationException)t;
            if (e.getErrorCode() == 404) {
                return Future.failedFuture((Throwable)new ClientErrorException(401, "bad credentials"));
            }
            return Future.failedFuture((Throwable)t);
        }).compose(credentialsOnRecord -> this.validateCredentials(deviceCredentials, (CredentialsObject)credentialsOnRecord)).compose(d -> Future.succeededFuture((Object)((Object)new DeviceUser(d.getTenantId(), d.getDeviceId())))).setHandler(resultHandler);
    }

    protected Future<Device> validateCredentials(DeviceCredentials deviceCredentials, CredentialsObject credentialsOnRecord) {
        Future result = Future.future();
        if (deviceCredentials.validate(credentialsOnRecord)) {
            result.complete((Object)new Device(deviceCredentials.getTenantId(), credentialsOnRecord.getDeviceId()));
        } else {
            result.fail((Throwable)new ClientErrorException(401, "bad credentials"));
        }
        return result;
    }

    public final void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        DeviceCredentials credentials = this.getCredentials(Objects.requireNonNull(authInfo));
        if (credentials == null) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new ClientErrorException(401, "malformed credentials")));
        } else {
            this.authenticate(credentials, (Handler<AsyncResult<DeviceUser>>)((Handler)s -> {
                if (s.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)((User)s.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)s.cause()));
                }
            }));
        }
    }

    protected abstract DeviceCredentials getCredentials(JsonObject var1);
}

