/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.TrustOptions;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonHelper;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.CommandConnection;
import org.eclipse.hono.client.CommandContext;
import org.eclipse.hono.client.CommandResponse;
import org.eclipse.hono.client.CommandResponseSender;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.client.MessageConsumer;
import org.eclipse.hono.client.MessageSender;
import org.eclipse.hono.client.RegistrationClient;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.TenantClient;
import org.eclipse.hono.config.ProtocolAdapterProperties;
import org.eclipse.hono.service.AbstractServiceBase;
import org.eclipse.hono.service.auth.ValidityBasedTrustOptions;
import org.eclipse.hono.service.monitoring.ConnectionEventProducer;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.Strings;
import org.eclipse.hono.util.TenantObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractProtocolAdapterBase<T extends ProtocolAdapterProperties>
extends AbstractServiceBase<T> {
    protected static final String CONTENT_TYPE_OCTET_STREAM = "application/octet-stream";
    private HonoClient messagingClient;
    private HonoClient registrationServiceClient;
    private HonoClient tenantServiceClient;
    private HonoClient credentialsServiceClient;
    private CommandConnection commandConnection;
    private ConnectionEventProducer connectionEventProducer;
    private final ConnectionEventProducer.Context connectionEventProducerContext = new ConnectionEventProducer.Context(){

        @Override
        public HonoClient getDeviceRegistryClient() {
            return AbstractProtocolAdapterBase.this.registrationServiceClient;
        }

        @Override
        public HonoClient getMessageSenderClient() {
            return AbstractProtocolAdapterBase.this.messagingClient;
        }
    };

    @Autowired
    public void setConfig(T configuration) {
        this.setSpecificConfig(configuration);
    }

    @Qualifier(value="tenant")
    @Autowired
    public final void setTenantServiceClient(HonoClient tenantClient) {
        this.tenantServiceClient = Objects.requireNonNull(tenantClient);
    }

    public final HonoClient getTenantServiceClient() {
        return this.tenantServiceClient;
    }

    protected final Future<TenantClient> getTenantClient() {
        return this.getTenantServiceClient().getOrCreateTenantClient();
    }

    @Qualifier(value="messaging")
    @Autowired
    public final void setHonoMessagingClient(HonoClient honoClient) {
        this.messagingClient = Objects.requireNonNull(honoClient);
    }

    public final HonoClient getHonoMessagingClient() {
        return this.messagingClient;
    }

    @Qualifier(value="registration")
    @Autowired
    public final void setRegistrationServiceClient(HonoClient registrationServiceClient) {
        this.registrationServiceClient = Objects.requireNonNull(registrationServiceClient);
    }

    public final HonoClient getRegistrationServiceClient() {
        return this.registrationServiceClient;
    }

    @Qualifier(value="credentials")
    @Autowired
    public final void setCredentialsServiceClient(HonoClient credentialsServiceClient) {
        this.credentialsServiceClient = Objects.requireNonNull(credentialsServiceClient);
    }

    public final HonoClient getCredentialsServiceClient() {
        return this.credentialsServiceClient;
    }

    @Autowired(required=false)
    public void setConnectionEventProducer(ConnectionEventProducer connectionEventProducer) {
        this.connectionEventProducer = connectionEventProducer;
    }

    public ConnectionEventProducer getConnectionEventProducer() {
        return this.connectionEventProducer;
    }

    protected abstract String getTypeName();

    protected Future<Integer> getTimeUntilDisconnect(TenantObject tenant, Integer deviceTtd) {
        Objects.requireNonNull(tenant);
        if (deviceTtd == null) {
            return Future.succeededFuture();
        }
        return Future.succeededFuture((Object)Math.min(tenant.getMaxTimeUntilDisconnect(this.getTypeName()), deviceTtd));
    }

    @Autowired
    public final void setCommandConnection(CommandConnection commandConnection) {
        this.commandConnection = Objects.requireNonNull(commandConnection);
    }

    public final CommandConnection getCommandConnection() {
        return this.commandConnection;
    }

    @Override
    protected final Future<Void> startInternal() {
        Future result = Future.future();
        if (Strings.isNullOrEmpty((Object)this.getTypeName())) {
            result.fail((Throwable)new IllegalStateException("adapter does not define a typeName"));
        } else if (this.tenantServiceClient == null) {
            result.fail((Throwable)new IllegalStateException("Tenant service client must be set"));
        } else if (this.messagingClient == null) {
            result.fail((Throwable)new IllegalStateException("AMQP Messaging Network client must be set"));
        } else if (this.registrationServiceClient == null) {
            result.fail((Throwable)new IllegalStateException("Device Registration service client must be set"));
        } else if (this.credentialsServiceClient == null) {
            result.fail((Throwable)new IllegalStateException("Credentials service client must be set"));
        } else if (this.commandConnection == null) {
            result.fail((Throwable)new IllegalStateException("Command & Control service client must be set"));
        } else {
            this.connectToService(this.tenantServiceClient, "Tenant service");
            this.connectToService(this.messagingClient, "AMQP Messaging Network");
            this.connectToService(this.registrationServiceClient, "Device Registration service");
            this.connectToService(this.credentialsServiceClient, "Credentials service");
            this.connectToService((HonoClient)this.commandConnection, "Command and Control service", (Handler<HonoClient>)((Handler)this::onCommandConnectionEstablished), (Handler<HonoClient>)((Handler)this::onCommandConnectionLost));
            this.doStart((Future<Void>)result);
        }
        return result;
    }

    protected void doStart(Future<Void> startFuture) {
        startFuture.complete();
    }

    @Override
    protected final Future<Void> stopInternal() {
        this.LOG.info("stopping protocol adapter");
        Future result = Future.future();
        Future doStopResult = Future.future();
        this.doStop((Future<Void>)doStopResult);
        doStopResult.compose(s -> this.closeServiceClients()).recover(t -> {
            this.LOG.info("error while stopping protocol adapter", t);
            return Future.failedFuture((Throwable)t);
        }).compose(s -> {
            result.complete();
            this.LOG.info("successfully stopped protocol adapter");
        }, result);
        return result;
    }

    private CompositeFuture closeServiceClients() {
        return CompositeFuture.all(this.closeServiceClient(this.tenantServiceClient), this.closeServiceClient(this.messagingClient), this.closeServiceClient(this.registrationServiceClient), this.closeServiceClient(this.credentialsServiceClient));
    }

    private Future<Void> closeServiceClient(HonoClient client) {
        Future shutdownTracker = Future.future();
        if (client == null) {
            shutdownTracker.complete();
        } else {
            client.shutdown(shutdownTracker.completer());
        }
        return shutdownTracker;
    }

    protected void doStop(Future<Void> stopFuture) {
        stopFuture.complete();
    }

    protected final Future<TenantObject> isAdapterEnabled(TenantObject tenantConfig) {
        if (tenantConfig.isAdapterEnabled(this.getTypeName())) {
            this.LOG.debug("protocol adapter [{}] is enabled for tenant [{}]", (Object)this.getTypeName(), (Object)tenantConfig.getTenantId());
            return Future.succeededFuture((Object)tenantConfig);
        }
        this.LOG.debug("protocol adapter [{}] is disabled for tenant [{}]", (Object)this.getTypeName(), (Object)tenantConfig.getTenantId());
        return Future.failedFuture((Throwable)new ClientErrorException(403, "adapter disabled for tenant"));
    }

    protected final Future<Void> checkDeviceRegistration(Device device, SpanContext context) {
        Objects.requireNonNull(device);
        return this.getRegistrationAssertion(device.getTenantId(), device.getDeviceId(), null, context).map(assertion -> null);
    }

    protected final Future<HonoClient> connectToService(HonoClient client, String serviceName) {
        return this.connectToService(client, serviceName, (Handler<HonoClient>)((Handler)onConnect -> {}), (Handler<HonoClient>)((Handler)onConnectionLost -> {}));
    }

    protected final Future<HonoClient> connectToService(HonoClient client, String serviceName, Handler<HonoClient> connectionEstablishedHandler, Handler<HonoClient> connectionLostHandler) {
        Objects.requireNonNull(client);
        Objects.requireNonNull(serviceName);
        Objects.requireNonNull(connectionEstablishedHandler);
        Objects.requireNonNull(connectionLostHandler);
        Handler<ProtonConnection> disconnectHandler = this.getHandlerForDisconnectHonoService(client, serviceName, connectionEstablishedHandler, connectionLostHandler);
        return client.connect(disconnectHandler).map(connectedClient -> {
            this.LOG.info("connected to {}", (Object)serviceName);
            connectionEstablishedHandler.handle(connectedClient);
            return connectedClient;
        }).recover(t -> {
            this.LOG.warn("failed to connect to {}", (Object)serviceName, t);
            return Future.failedFuture((Throwable)t);
        });
    }

    protected void onCommandConnectionLost(HonoClient commandConnection) {
    }

    protected void onCommandConnectionEstablished(HonoClient commandConnection) {
    }

    private Handler<ProtonConnection> getHandlerForDisconnectHonoService(HonoClient client, String serviceName, Handler<HonoClient> connectHandler, Handler<HonoClient> connectionLostHandler) {
        return connection -> {
            connectionLostHandler.handle((Object)client);
            this.vertx.setTimer(500L, reconnect -> {
                this.LOG.info("attempting to reconnect to {}", (Object)serviceName);
                client.connect(this.getHandlerForDisconnectHonoService(client, serviceName, connectHandler, connectionLostHandler)).setHandler(connectAttempt -> {
                    if (connectAttempt.succeeded()) {
                        this.LOG.info("reconnected to {}", (Object)serviceName);
                        connectHandler.handle((Object)((HonoClient)connectAttempt.result()));
                    } else {
                        this.LOG.debug("cannot reconnect to {}: {}", (Object)serviceName, (Object)connectAttempt.cause().getMessage());
                    }
                });
            });
        };
    }

    protected Future<Void> isConnected() {
        Future tenantCheck = Optional.ofNullable(this.tenantServiceClient).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new ServerErrorException(503, "Tenant service client is not set")));
        Future registrationCheck = Optional.ofNullable(this.registrationServiceClient).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new ServerErrorException(503, "Device Registration service client is not set")));
        Future credentialsCheck = Optional.ofNullable(this.credentialsServiceClient).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new ServerErrorException(503, "Credentials service client is not set")));
        Future messagingCheck = Optional.ofNullable(this.messagingClient).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new ServerErrorException(503, "Messaging client is not set")));
        Future commandCheck = Optional.ofNullable(this.commandConnection).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new ServerErrorException(503, "Command & Control client is not set")));
        return CompositeFuture.all((Future)tenantCheck, (Future)registrationCheck, (Future)credentialsCheck, (Future)messagingCheck, (Future)commandCheck).map(ok -> null);
    }

    protected final Future<MessageConsumer> createCommandConsumer(String tenantId, String deviceId, Handler<CommandContext> commandConsumer, Handler<Void> closeHandler) {
        return this.commandConnection.createCommandConsumer(tenantId, deviceId, commandContext -> {
            Tags.COMPONENT.set(commandContext.getCurrentSpan(), this.getTypeName());
            commandConsumer.handle(commandContext);
        }, closeHandler);
    }

    protected final void closeCommandConsumer(String tenantId, String deviceId) {
        this.getCommandConnection().closeCommandConsumer(tenantId, deviceId).otherwise(t -> {
            this.LOG.warn("cannot close command consumer [tenant-id: {}, device-id: {}]: {}", new Object[]{tenantId, deviceId, t.getMessage()});
            return null;
        });
    }

    protected final Future<CommandResponseSender> createCommandResponseSender(String tenantId, String replyId) {
        return this.commandConnection.getCommandResponseSender(tenantId, replyId);
    }

    protected final Future<ProtonDelivery> sendCommandResponse(String tenantId, CommandResponse response, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(response);
        Future<CommandResponseSender> senderTracker = this.createCommandResponseSender(tenantId, response.getReplyToId());
        return senderTracker.compose(sender -> sender.sendCommandResponse(response, context)).map(delivery -> {
            ((CommandResponseSender)senderTracker.result()).close(c -> {});
            return delivery;
        }).recover(t -> {
            if (senderTracker.succeeded()) {
                ((CommandResponseSender)senderTracker.result()).close(c -> {});
            }
            return Future.failedFuture((Throwable)t);
        });
    }

    protected final Future<MessageSender> getTelemetrySender(String tenantId) {
        return this.getHonoMessagingClient().getOrCreateTelemetrySender(tenantId);
    }

    protected final Future<MessageSender> getEventSender(String tenantId) {
        return this.getHonoMessagingClient().getOrCreateEventSender(tenantId);
    }

    protected final Future<RegistrationClient> getRegistrationClient(String tenantId) {
        return this.getRegistrationServiceClient().getOrCreateRegistrationClient(tenantId);
    }

    @Deprecated
    protected final Future<JsonObject> getRegistrationAssertion(String tenantId, String deviceId, Device authenticatedDevice) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Future<String> gatewayId = this.getGatewayId(tenantId, deviceId, authenticatedDevice);
        return gatewayId.compose(gwId -> this.getRegistrationClient(tenantId)).compose(client -> client.assertRegistration(deviceId, (String)gatewayId.result()));
    }

    protected final Future<JsonObject> getRegistrationAssertion(String tenantId, String deviceId, Device authenticatedDevice, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Future<String> gatewayId = this.getGatewayId(tenantId, deviceId, authenticatedDevice);
        return gatewayId.compose(gwId -> this.getRegistrationClient(tenantId)).compose(client -> client.assertRegistration(deviceId, (String)gatewayId.result(), context));
    }

    private Future<String> getGatewayId(String tenantId, String deviceId, Device authenticatedDevice) {
        Future result = Future.future();
        if (authenticatedDevice == null) {
            result.complete(null);
        } else if (tenantId.equals(authenticatedDevice.getTenantId())) {
            if (deviceId.equals(authenticatedDevice.getDeviceId())) {
                result.complete(null);
            } else {
                result.complete((Object)authenticatedDevice.getDeviceId());
            }
        } else {
            result.fail((Throwable)new ClientErrorException(403, "cannot publish data for device of other tenant"));
        }
        return result;
    }

    @Deprecated
    protected final Future<TenantObject> getTenantConfiguration(String tenantId) {
        Objects.requireNonNull(tenantId);
        return this.getTenantClient().compose(client -> client.get(tenantId));
    }

    protected final Future<TenantObject> getTenantConfiguration(String tenantId, SpanContext context) {
        Objects.requireNonNull(tenantId);
        return this.getTenantClient().compose(client -> client.get(tenantId, context));
    }

    protected final void addProperties(Message message, JsonObject registrationInfo) {
        this.addProperties(message, registrationInfo, true);
    }

    protected final void addProperties(Message message, JsonObject registrationInfo, boolean regAssertionRequired) {
        JsonObject defaults;
        if (regAssertionRequired) {
            String registrationAssertion = registrationInfo.getString("assertion");
            MessageHelper.addRegistrationAssertion((Message)message, (String)registrationAssertion);
        }
        MessageHelper.addProperty((Message)message, (String)"orig_adapter", (Object)this.getTypeName());
        if (((ProtocolAdapterProperties)this.getConfig()).isDefaultsEnabled() && (defaults = registrationInfo.getJsonObject("defaults")) != null) {
            this.addDefaults(message, defaults);
        }
        if (Strings.isNullOrEmpty((Object)message.getContentType())) {
            message.setContentType(CONTENT_TYPE_OCTET_STREAM);
        }
        if (((ProtocolAdapterProperties)this.getConfig()).isJmsVendorPropsEnabled()) {
            MessageHelper.addJmsVendorProperties((Message)message);
        }
    }

    private void addDefaults(Message message, JsonObject defaults) {
        defaults.forEach(prop -> {
            switch ((String)prop.getKey()) {
                case "content-type": {
                    if (!Strings.isNullOrEmpty((Object)message.getContentType()) || !String.class.isInstance(prop.getValue())) break;
                    message.setContentType((String)prop.getValue());
                    break;
                }
                case "content-encoding": {
                    if (!Strings.isNullOrEmpty((Object)message.getContentEncoding()) || !String.class.isInstance(prop.getValue())) break;
                    message.setContentEncoding((String)prop.getValue());
                    break;
                }
                case "absolute-expiry-time": 
                case "correlation-id": 
                case "creation-time": 
                case "group-id": 
                case "group-sequence": 
                case "message-id": 
                case "reply-to": 
                case "reply-to-group-id": 
                case "subject": 
                case "to": 
                case "user-id": {
                    this.LOG.debug("ignoring default property [{}] registered for device", prop.getKey());
                    break;
                }
                default: {
                    MessageHelper.addProperty((Message)message, (String)((String)prop.getKey()), prop.getValue());
                }
            }
        });
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler handler) {
        handler.register("connection-to-services", status -> this.isConnected().map(connected -> {
            status.tryComplete((Object)Status.OK());
            return null;
        }).otherwise(t -> {
            status.tryComplete((Object)Status.KO());
            return null;
        }));
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler handler) {
        this.registerEventLoopBlockedCheck(handler);
    }

    protected final Message newMessage(ResourceIdentifier target, boolean regAssertionRequired, String publishAddress, String contentType, Buffer payload, JsonObject registrationInfo, Integer timeUntilDisconnect) {
        Objects.requireNonNull(target);
        Objects.requireNonNull(registrationInfo);
        Message msg = ProtonHelper.message();
        msg.setAddress(target.getBasePath());
        MessageHelper.addDeviceId((Message)msg, (String)target.getResourceId());
        if (!regAssertionRequired) {
            MessageHelper.annotate((Message)msg, (ResourceIdentifier)target);
        }
        if (publishAddress != null) {
            MessageHelper.addProperty((Message)msg, (String)"orig_address", (Object)publishAddress);
        }
        MessageHelper.setPayload((Message)msg, (String)contentType, (Buffer)payload);
        msg.setContentType(contentType);
        if (timeUntilDisconnect != null) {
            MessageHelper.addTimeUntilDisconnect((Message)msg, (int)timeUntilDisconnect);
        }
        MessageHelper.setCreationTime((Message)msg);
        this.addProperties(msg, registrationInfo, regAssertionRequired);
        return msg;
    }

    protected Future<?> sendConnectedEvent(String remoteId, Device authenticatedDevice) {
        if (this.connectionEventProducer != null) {
            return this.connectionEventProducer.connected(this.connectionEventProducerContext, remoteId, this.getTypeName(), authenticatedDevice, null);
        }
        return Future.succeededFuture();
    }

    protected Future<?> sendDisconnectedEvent(String remoteId, Device authenticatedDevice) {
        if (this.connectionEventProducer != null) {
            return this.connectionEventProducer.disconnected(this.connectionEventProducerContext, remoteId, this.getTypeName(), authenticatedDevice, null);
        }
        return Future.succeededFuture();
    }

    @Deprecated
    protected final Future<ProtonDelivery> sendConnectedTtdEvent(String tenant, String deviceId, Device authenticatedDevice) {
        return this.sendConnectedTtdEvent(tenant, deviceId, authenticatedDevice, null);
    }

    protected final Future<ProtonDelivery> sendConnectedTtdEvent(String tenant, String deviceId, Device authenticatedDevice, SpanContext context) {
        return this.sendTtdEvent(tenant, deviceId, authenticatedDevice, -1, context);
    }

    @Deprecated
    protected final Future<ProtonDelivery> sendDisconnectedTtdEvent(String tenant, String deviceId, Device authenticatedDevice) {
        return this.sendDisconnectedTtdEvent(tenant, deviceId, authenticatedDevice, null);
    }

    protected final Future<ProtonDelivery> sendDisconnectedTtdEvent(String tenant, String deviceId, Device authenticatedDevice, SpanContext context) {
        return this.sendTtdEvent(tenant, deviceId, authenticatedDevice, 0, context);
    }

    @Deprecated
    protected final Future<ProtonDelivery> sendTtdEvent(String tenant, String deviceId, Device authenticatedDevice, Integer ttd) {
        return this.sendTtdEvent(tenant, deviceId, authenticatedDevice, ttd, null);
    }

    protected final Future<ProtonDelivery> sendTtdEvent(String tenant, String deviceId, Device authenticatedDevice, Integer ttd, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(ttd);
        Future<JsonObject> tokenTracker = this.getRegistrationAssertion(tenant, deviceId, authenticatedDevice, context);
        Future<TenantObject> tenantConfigTracker = this.getTenantConfiguration(tenant, context);
        Future<MessageSender> senderTracker = this.getEventSender(tenant);
        return CompositeFuture.all(tokenTracker, tenantConfigTracker, senderTracker).compose(ok -> {
            if (((TenantObject)tenantConfigTracker.result()).isAdapterEnabled(this.getTypeName())) {
                MessageSender sender = (MessageSender)senderTracker.result();
                Message msg = this.newMessage(ResourceIdentifier.from((String)"event", (String)tenant, (String)deviceId), ((MessageSender)senderTracker.result()).isRegistrationAssertionRequired(), "event", "application/vnd.eclipse-hono-empty-notification", null, (JsonObject)tokenTracker.result(), ttd);
                return sender.sendAndWaitForOutcome(msg, context);
            }
            return Future.failedFuture((Throwable)new ClientErrorException(403));
        });
    }

    protected boolean isPayloadOfIndicatedType(Buffer payload, String contentType) {
        if (payload == null || payload.length() == 0) {
            return "application/vnd.eclipse-hono-empty-notification".equals(contentType);
        }
        return !"application/vnd.eclipse-hono-empty-notification".equals(contentType);
    }

    protected void onCloseCommandConsumer(String tenant, String deviceId, BiConsumer<ProtonDelivery, Message> commandMessageConsumer) {
        this.LOG.debug("command consumer closed [tenantId: {}, deviceId: {}] - no command will be received for this device anymore", (Object)tenant, (Object)deviceId);
    }

    protected void registerEventLoopBlockedCheck(HealthCheckHandler handler) {
        handler.register("event-loop-blocked-check", ((ProtocolAdapterProperties)this.getConfig()).getEventLoopBlockedCheckTimeout(), procedure -> {
            Context currentContext = Vertx.currentContext();
            if (currentContext != this.context) {
                this.context.runOnContext(action -> procedure.complete((Object)Status.OK()));
            } else {
                this.LOG.info("Protocol Adapter - HealthCheck Server context match. Assume protocol adapter is alive.");
                procedure.complete((Object)Status.OK());
            }
        });
    }

    @Override
    protected TrustOptions getServerTrustOptions() {
        return Optional.ofNullable(((ProtocolAdapterProperties)this.getConfig()).getTrustOptions()).orElseGet(() -> {
            if (((ProtocolAdapterProperties)this.getConfig()).isAuthenticationRequired()) {
                return new ValidityBasedTrustOptions();
            }
            return null;
        });
    }
}

