/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import io.vertx.core.Vertx;
import java.util.Objects;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.RequestResponseEndpoint;
import org.eclipse.hono.service.registration.RegistrationMessageFilter;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.RegistrationConstants;
import org.eclipse.hono.util.ResourceIdentifier;
import org.springframework.beans.factory.annotation.Autowired;

public class RegistrationAmqpEndpoint
extends RequestResponseEndpoint<ServiceConfigProperties> {
    @Autowired
    public RegistrationAmqpEndpoint(Vertx vertx) {
        super(Objects.requireNonNull(vertx));
    }

    @Override
    public final String getName() {
        return "registration";
    }

    @Override
    public final void processRequest(Message msg, ResourceIdentifier targetAddress, HonoUser clientPrincipal) {
        EventBusMessage registrationMsg = EventBusMessage.forOperation((Message)msg).setReplyToAddress(msg).setAppCorrelationId(msg).setCorrelationId(msg).setTenant(targetAddress.getTenantId()).setDeviceId(msg).setGatewayId(msg).setJsonPayload(msg);
        this.vertx.eventBus().send("registration.in", (Object)registrationMsg.toJson());
    }

    @Override
    protected boolean passesFormalVerification(ResourceIdentifier linkTarget, Message msg) {
        return RegistrationMessageFilter.verify(linkTarget, msg);
    }

    @Override
    protected final Message getAmqpReply(EventBusMessage message) {
        return RegistrationConstants.getAmqpReply((String)"registration", (EventBusMessage)message);
    }
}

