/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.monitoring;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.BiFunction;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.client.MessageSender;
import org.eclipse.hono.service.auth.device.Device;
import org.eclipse.hono.service.monitoring.ConnectionEventProducer;

public abstract class AbstractMessageSenderConnectionEventProducer
implements ConnectionEventProducer {
    private final HonoClient deviceRegistryClient;
    private final HonoClient messageSenderClient;
    private final BiFunction<HonoClient, String, Future<MessageSender>> messageSenderSource;

    protected AbstractMessageSenderConnectionEventProducer(HonoClient deviceRegistryClient, HonoClient messageSenderClient, BiFunction<HonoClient, String, Future<MessageSender>> messageSenderSource) {
        Objects.requireNonNull(deviceRegistryClient);
        Objects.requireNonNull(messageSenderClient);
        Objects.requireNonNull(messageSenderSource);
        this.deviceRegistryClient = deviceRegistryClient;
        this.messageSenderClient = messageSenderClient;
        this.messageSenderSource = messageSenderSource;
    }

    @Override
    public Future<?> connected(String remoteId, String protocolAdapter, Device authenticatedDevice, JsonObject data) {
        return this.sendNotificationEvent(authenticatedDevice, protocolAdapter, remoteId, "connected", data);
    }

    @Override
    public Future<?> disconnected(String remoteId, String protocolAdapter, Device authenticatedDevice, JsonObject data) {
        return this.sendNotificationEvent(authenticatedDevice, protocolAdapter, remoteId, "disconnected", data);
    }

    private Future<?> sendNotificationEvent(Device authenticatedDevice, String protocolAdapter, String remoteId, String cause, JsonObject data) {
        if (authenticatedDevice == null) {
            return Future.succeededFuture();
        }
        Future assertionFuture = this.deviceRegistryClient.getOrCreateRegistrationClient(authenticatedDevice.getTenantId()).compose(registrationClient -> registrationClient.assertRegistration(authenticatedDevice.getDeviceId()).map(registration -> registration.getString("assertion")));
        Future<MessageSender> senderFuture = this.getOrCreateSender(authenticatedDevice);
        return CompositeFuture.all((Future)assertionFuture, senderFuture).compose(f -> {
            String deviceId = authenticatedDevice.getDeviceId();
            JsonObject payload = new JsonObject();
            payload.put("cause", cause);
            payload.put("remote-id", remoteId);
            payload.put("source", protocolAdapter);
            if (data != null) {
                payload.put("data", data);
            }
            return ((MessageSender)senderFuture.result()).send(deviceId, payload.encode().getBytes(StandardCharsets.UTF_8), "application/vnd.eclipse-hono-dc-notification+json", (String)assertionFuture.result());
        });
    }

    private Future<MessageSender> getOrCreateSender(Device device) {
        return this.messageSenderSource.apply(this.messageSenderClient, device.getTenantId());
    }
}

