/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.metric;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.eclipse.hono.service.metric.Metrics;

public abstract class MicrometerBasedMetrics
implements Metrics {
    protected final MeterRegistry registry;
    private final Map<String, AtomicLong> authenticatedConnections = new ConcurrentHashMap<String, AtomicLong>();
    private final AtomicLong unauthenticatedConnections;

    public MicrometerBasedMetrics(MeterRegistry registry) {
        Objects.requireNonNull(registry);
        this.registry = registry;
        this.unauthenticatedConnections = (AtomicLong)registry.gauge("hono.connections.unauthenticated", (Number)new AtomicLong());
    }

    @Override
    public final void incrementConnections(String tenantId) {
        this.gaugeForTenant("hono.connections.authenticated", this.authenticatedConnections, tenantId, AtomicLong::new).incrementAndGet();
    }

    @Override
    public final void decrementConnections(String tenantId) {
        this.gaugeForTenant("hono.connections.authenticated", this.authenticatedConnections, tenantId, AtomicLong::new).decrementAndGet();
    }

    @Override
    public final void incrementUnauthenticatedConnections() {
        this.unauthenticatedConnections.incrementAndGet();
    }

    @Override
    public final void decrementUnauthenticatedConnections() {
        this.unauthenticatedConnections.decrementAndGet();
    }

    @Override
    public final void incrementProcessedMessages(String type, String tenantId) {
        this.registry.counter("hono.messages.processed", (Iterable)Tags.of((String)"tenant", (String)tenantId).and("type", type)).increment();
    }

    @Override
    public final void incrementUndeliverableMessages(String type, String tenantId) {
        this.registry.counter("hono.messages.undeliverable", (Iterable)Tags.of((String)"tenant", (String)tenantId).and("type", type)).increment();
    }

    @Override
    public final void incrementProcessedPayload(String type, String tenantId, long payloadSize) {
        if (payloadSize < 0L) {
            return;
        }
        this.registry.counter("hono.messages.processed.payload", (Iterable)Tags.of((String)"tenant", (String)tenantId).and("type", type)).increment((double)payloadSize);
    }

    @Override
    public final void incrementCommandDeliveredToDevice(String tenantId) {
        this.registry.counter("hono.commands.device.delivered", (Iterable)Tags.of((String)"tenant", (String)tenantId)).increment();
    }

    @Override
    public final void incrementNoCommandReceivedAndTTDExpired(String tenantId) {
        this.registry.counter("hono.commands.ttd.expired", (Iterable)Tags.of((String)"tenant", (String)tenantId)).increment();
    }

    @Override
    public final void incrementCommandResponseDeliveredToApplication(String tenantId) {
        this.registry.counter("hono.commands.response.delivered", (Iterable)Tags.of((String)"tenant", (String)tenantId)).increment();
    }

    protected <T extends Number> T gaugeForKey(String name, Map<String, T> map, String key, Tags tags, Supplier<T> instanceSupplier) {
        return (T)map.computeIfAbsent(key, a -> this.registry.gauge(name, (Iterable)tags, (Number)instanceSupplier.get()));
    }

    protected <T extends Number> T gaugeForTenant(String name, Map<String, T> map, String tenant, Supplier<T> instanceSupplier) {
        return this.gaugeForKey(name, map, tenant, Tags.of((String)"tenant", (String)tenant), instanceSupplier);
    }
}

