/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.metric;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.graphite.GraphiteConfig;
import io.micrometer.graphite.GraphiteHierarchicalNameMapper;
import io.micrometer.graphite.GraphiteMeterRegistry;
import io.micrometer.spring.autoconfigure.MeterRegistryCustomizer;
import io.vertx.core.metrics.MetricsOptions;
import java.util.ArrayList;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ConditionalOnProperty(name={"hono.metrics.legacy"}, havingValue="true", matchIfMissing=true)
@PropertySource(value={"classpath:org/eclipse/hono/service/metric/legacy.properties"})
public class LegacyMetricsConfig {
    @Bean
    public MetricsOptions metricsOptions() {
        return new MetricsOptions();
    }

    @Bean
    public GraphiteMeterRegistry graphiteMeterRegistry(GraphiteConfig config, Clock clock) {
        return new GraphiteMeterRegistry(config, clock, this.legacyGraphiteFormatMapper(new GraphiteHierarchicalNameMapper(config.tagsAsPrefix())));
    }

    @Bean
    public MeterRegistryCustomizer<GraphiteMeterRegistry> legacyMeterFilters() {
        return r -> r.config().namingConvention(NamingConvention.dot).meterFilter(MeterFilter.replaceTagValues((String)"host", host -> host.replace('.', '_'), (String[])new String[0])).meterFilter(MeterFilter.ignoreTags((String[])new String[]{"component"})).meterFilter(this.meterTypeMapper());
    }

    private MeterFilter meterTypeMapper() {
        return new MeterFilter(){

            public Meter.Id map(Meter.Id id) {
                String name = id.getName();
                if (!name.startsWith("hono.")) {
                    return id;
                }
                name = name.substring("hono.".length());
                ArrayList<Tag> newTags = new ArrayList<Tag>(id.getTags());
                newTags.add(Tag.of((String)"hono", (String)"hono"));
                if ("connections.authenticated".equals(name) || "connections.unauthenticated".equals(name) || "messages.underliverable".equals(name)) {
                    newTags.add(Tag.of((String)"meterType", (String)"counter"));
                    newTags.add(Tag.of((String)"typeSuffix", (String)"count"));
                } else if (name.startsWith("messages.")) {
                    newTags.add(Tag.of((String)"meterType", (String)"meter"));
                    newTags.add(Tag.of((String)"subName", (String)name.substring("messages.".length())));
                    name = "messages";
                } else if (name.startsWith("payload.") || name.startsWith("command.")) {
                    newTags.add(Tag.of((String)"meterType", (String)"meter"));
                }
                return new Meter.Id(name, newTags, id.getBaseUnit(), id.getDescription(), id.getType());
            }
        };
    }

    private HierarchicalNameMapper legacyGraphiteFormatMapper(GraphiteHierarchicalNameMapper defaultMapper) {
        return (id, convention) -> {
            if (id.getTag("hono") == null) {
                return defaultMapper.toHierarchicalName(id, convention);
            }
            return LegacyMetricsConfig.amendWithTags(id.getConventionName(convention), id, new String[]{"host", "meterType", "hono", "protocol"}, new String[]{"type", "tenant", "subName", "typeSuffix"});
        };
    }

    private static String amendWithTags(String name, Meter.Id id, String[] prefixTags, String[] suffixTags) {
        StringBuilder sb = new StringBuilder();
        LegacyMetricsConfig.addTags(sb, id, prefixTags);
        if (sb.length() > 0) {
            sb.append('.');
            sb.append(name);
        }
        LegacyMetricsConfig.addTags(sb, id, suffixTags);
        return sb.toString();
    }

    private static void addTags(StringBuilder sb, Meter.Id id, String[] tags) {
        for (String tag : tags) {
            String value = id.getTag(tag);
            if (value == null) continue;
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(value.replace(' ', '_'));
        }
    }
}

