/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.AbstractServiceBase;
import org.eclipse.hono.service.http.DefaultFailureHandler;
import org.eclipse.hono.service.http.HttpEndpoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public abstract class HttpServiceBase<T extends ServiceConfigProperties>
extends AbstractServiceBase<T> {
    protected static final String DEFAULT_UPLOADS_DIRECTORY = "/tmp";
    private final Set<HttpEndpoint> endpoints = new HashSet<HttpEndpoint>();
    @Value(value="${spring.profiles.active:}")
    private String activeProfiles;
    private HttpServer server;
    private HttpServer insecureServer;

    @Autowired(required=false)
    public final void addEndpoints(Set<HttpEndpoint> definedEndpoints) {
        this.endpoints.addAll((Collection<HttpEndpoint>)Objects.requireNonNull(definedEndpoints));
    }

    public final void addEndpoint(HttpEndpoint ep) {
        this.LOG.debug("registering endpoint [{}]", (Object)ep.getName());
        this.endpoints.add(Objects.requireNonNull(ep));
    }

    @Autowired
    @Qualifier(value="rest")
    public final void setConfig(T configuration) {
        this.setSpecificConfig(configuration);
    }

    @Override
    public int getPortDefaultValue() {
        return 8443;
    }

    @Override
    public int getInsecurePortDefaultValue() {
        return 8080;
    }

    @Override
    protected final int getActualPort() {
        return this.server != null ? this.server.actualPort() : -1;
    }

    @Override
    protected final int getActualInsecurePort() {
        return this.insecureServer != null ? this.insecureServer.actualPort() : -1;
    }

    protected Future<Void> preStartServers() {
        return Future.succeededFuture();
    }

    @Override
    protected final Future<Void> startInternal() {
        return this.preStartServers().compose(s -> this.checkPortConfiguration()).compose(s -> this.startEndpoints()).compose(router -> CompositeFuture.all(this.bindSecureHttpServer((Router)router), this.bindInsecureHttpServer((Router)router))).compose(s -> this.onStartupSuccess());
    }

    protected Future<Void> onStartupSuccess() {
        return Future.succeededFuture();
    }

    protected Router createRouter() {
        Router router = Router.router((Vertx)this.vertx);
        this.LOG.info("limiting size of inbound request body to {} bytes", (Object)((ServiceConfigProperties)this.getConfig()).getMaxPayloadSize());
        router.route().handler((Handler)BodyHandler.create().setBodyLimit((long)((ServiceConfigProperties)this.getConfig()).getMaxPayloadSize()).setUploadsDirectory(DEFAULT_UPLOADS_DIRECTORY)).failureHandler((Handler)new DefaultFailureHandler());
        return router;
    }

    private void addEndpointRoutes(Router router) {
        for (HttpEndpoint ep : this.endpoints) {
            ep.addRoutes(router);
        }
    }

    protected void addCustomRoutes(Router router) {
    }

    protected HttpServerOptions getHttpServerOptions() {
        HttpServerOptions options = new HttpServerOptions();
        options.setHost(((ServiceConfigProperties)this.getConfig()).getBindAddress()).setPort(((ServiceConfigProperties)this.getConfig()).getPort(this.getPortDefaultValue())).setMaxChunkSize(4096);
        this.addTlsKeyCertOptions((NetServerOptions)options);
        this.addTlsTrustOptions((NetServerOptions)options);
        return options;
    }

    protected HttpServerOptions getInsecureHttpServerOptions() {
        HttpServerOptions options = new HttpServerOptions();
        options.setHost(((ServiceConfigProperties)this.getConfig()).getInsecurePortBindAddress()).setPort(((ServiceConfigProperties)this.getConfig()).getInsecurePort(this.getInsecurePortDefaultValue())).setMaxChunkSize(4096);
        return options;
    }

    private Future<HttpServer> bindSecureHttpServer(Router router) {
        if (this.isSecurePortEnabled()) {
            String bindAddress;
            Future result = Future.future();
            String string = bindAddress = this.server == null ? ((ServiceConfigProperties)this.getConfig()).getBindAddress() : "?";
            if (this.server == null) {
                this.server = this.vertx.createHttpServer(this.getHttpServerOptions());
            }
            this.server.requestHandler(arg_0 -> ((Router)router).accept(arg_0)).listen(bindAttempt -> {
                if (bindAttempt.succeeded()) {
                    if (this.getPort() == this.getPortDefaultValue()) {
                        this.LOG.info("server listens on standard secure port [{}:{}]", (Object)bindAddress, (Object)this.server.actualPort());
                    } else {
                        this.LOG.warn("server listens on non-standard secure port [{}:{}], default is {}", new Object[]{bindAddress, this.server.actualPort(), this.getPortDefaultValue()});
                    }
                    result.complete(bindAttempt.result());
                } else {
                    this.LOG.error("cannot bind to secure port", bindAttempt.cause());
                    result.fail(bindAttempt.cause());
                }
            });
            return result;
        }
        return Future.succeededFuture();
    }

    private Future<HttpServer> bindInsecureHttpServer(Router router) {
        if (this.isInsecurePortEnabled()) {
            String bindAddress;
            Future result = Future.future();
            String string = bindAddress = this.insecureServer == null ? ((ServiceConfigProperties)this.getConfig()).getInsecurePortBindAddress() : "?";
            if (this.insecureServer == null) {
                this.insecureServer = this.vertx.createHttpServer(this.getInsecureHttpServerOptions());
            }
            this.insecureServer.requestHandler(arg_0 -> ((Router)router).accept(arg_0)).listen(bindAttempt -> {
                if (bindAttempt.succeeded()) {
                    if (this.getInsecurePort() == this.getInsecurePortDefaultValue()) {
                        this.LOG.info("server listens on standard insecure port [{}:{}]", (Object)bindAddress, (Object)this.insecureServer.actualPort());
                    } else {
                        this.LOG.warn("server listens on non-standard insecure port [{}:{}], default is {}", new Object[]{bindAddress, this.insecureServer.actualPort(), this.getInsecurePortDefaultValue()});
                    }
                    result.complete(bindAttempt.result());
                } else {
                    this.LOG.error("cannot bind to insecure port", bindAttempt.cause());
                    result.fail(bindAttempt.cause());
                }
            });
            return result;
        }
        return Future.succeededFuture();
    }

    private Future<Router> startEndpoints() {
        Future startFuture = Future.future();
        Router router = this.createRouter();
        if (router == null) {
            startFuture.fail("no router configured");
        } else {
            this.addEndpointRoutes(router);
            this.addCustomRoutes(router);
            ArrayList<Future<Void>> endpointFutures = new ArrayList<Future<Void>>(this.endpoints.size());
            for (HttpEndpoint ep : this.endpoints) {
                this.LOG.info("starting endpoint [name: {}, class: {}]", (Object)ep.getName(), (Object)ep.getClass().getName());
                endpointFutures.add(ep.start());
            }
            CompositeFuture.all(endpointFutures).setHandler(startup -> {
                if (startup.succeeded()) {
                    startFuture.complete((Object)router);
                } else {
                    startFuture.fail(startup.cause());
                }
            });
        }
        return startFuture;
    }

    private Future<Void> stopEndpoints() {
        Future stopFuture = Future.future();
        ArrayList<Future<Void>> endpointFutures = new ArrayList<Future<Void>>(this.endpoints.size());
        for (HttpEndpoint ep : this.endpoints) {
            this.LOG.info("stopping endpoint [name: {}, class: {}]", (Object)ep.getName(), (Object)ep.getClass().getName());
            endpointFutures.add(ep.stop());
        }
        CompositeFuture.all(endpointFutures).setHandler(shutdown -> {
            if (shutdown.succeeded()) {
                stopFuture.complete();
            } else {
                stopFuture.fail(shutdown.cause());
            }
        });
        return stopFuture;
    }

    @Override
    protected final Future<Void> stopInternal() {
        return this.preShutdown().compose(s -> CompositeFuture.all(this.stopServer(), this.stopInsecureServer())).compose(s -> this.stopEndpoints()).compose(v -> this.postShutdown());
    }

    private Future<Void> stopServer() {
        Future serverStopTracker = Future.future();
        if (this.server != null) {
            this.LOG.info("stopping secure HTTP server [{}:{}]", (Object)this.getBindAddress(), (Object)this.getActualPort());
            this.server.close(serverStopTracker.completer());
        } else {
            serverStopTracker.complete();
        }
        return serverStopTracker;
    }

    private Future<Void> stopInsecureServer() {
        Future insecureServerStopTracker = Future.future();
        if (this.insecureServer != null) {
            this.LOG.info("stopping insecure HTTP server [{}:{}]", (Object)this.getInsecurePortBindAddress(), (Object)this.getActualInsecurePort());
            this.insecureServer.close(insecureServerStopTracker.completer());
        } else {
            insecureServerStopTracker.complete();
        }
        return insecureServerStopTracker;
    }

    protected Future<Void> preShutdown() {
        return Future.succeededFuture();
    }

    protected Future<Void> postShutdown() {
        return Future.succeededFuture();
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler handler) {
        for (HttpEndpoint ep : this.endpoints) {
            ep.registerReadinessChecks(handler);
        }
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler handler) {
        for (HttpEndpoint ep : this.endpoints) {
            ep.registerLivenessChecks(handler);
        }
    }
}

