/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.credentials;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.credentials.BaseCredentialsService;
import org.eclipse.hono.service.credentials.CompleteCredentialsService;
import org.eclipse.hono.util.CredentialsConstants;
import org.eclipse.hono.util.CredentialsObject;
import org.eclipse.hono.util.CredentialsResult;
import org.eclipse.hono.util.EventBusMessage;

public abstract class CompleteBaseCredentialsService<T>
extends BaseCredentialsService<T>
implements CompleteCredentialsService {
    private static final Pattern BCRYPT_PATTERN = Pattern.compile("\\A\\$2a\\$(\\d{1,2})\\$[./0-9A-Za-z]{53}");
    private static final int DEFAULT_MAX_BCRYPT_ITERATIONS = 10;

    @Override
    public final Future<EventBusMessage> processRequest(EventBusMessage request) {
        Objects.requireNonNull(request);
        String operation = request.getOperation();
        switch (CredentialsConstants.CredentialsAction.from((String)operation)) {
            case get: {
                return this.processGetRequest(request);
            }
            case add: {
                return this.processAddRequest(request);
            }
            case update: {
                return this.processUpdateRequest(request);
            }
            case remove: {
                return this.processRemoveRequest(request);
            }
        }
        return this.processCustomCredentialsMessage(request);
    }

    private Future<EventBusMessage> processAddRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        CredentialsObject payload = Optional.ofNullable(request.getJsonPayload()).map(json -> (CredentialsObject)json.mapTo(CredentialsObject.class)).orElse(null);
        if (tenantId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, "missing tenant ID"));
        }
        if (payload == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, "missing payload"));
        }
        try {
            payload.checkValidity(this::checkSecret);
            Future result = Future.future();
            this.add(tenantId, JsonObject.mapFrom((Object)payload), (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result.completer());
            return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(payload.getDeviceId()).setCacheDirective(res.getCacheDirective()));
        }
        catch (IllegalStateException e) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, e.getMessage()));
        }
    }

    private void checkSecret(String type, JsonObject secret) {
        block3 : switch (type) {
            case "hashed-password": {
                String hashFunction;
                switch (hashFunction = secret.getString("hash-function")) {
                    case "bcrypt": {
                        this.verifyBcryptPasswordHash(secret);
                        break block3;
                    }
                }
            }
        }
    }

    protected void verifyBcryptPasswordHash(JsonObject secret) {
        String pwdHash = secret.getString("pwd-hash");
        Matcher matcher = BCRYPT_PATTERN.matcher(pwdHash);
        if (matcher.matches()) {
            int iterations = Integer.valueOf(matcher.group(1));
            if (iterations > this.getMaxBcryptIterations()) {
                throw new IllegalArgumentException("max number of BCrypt iterations exceeded");
            }
        } else {
            throw new IllegalArgumentException("not a BCrypt hash");
        }
    }

    protected int getMaxBcryptIterations() {
        return 10;
    }

    private Future<EventBusMessage> processUpdateRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        CredentialsObject payload = Optional.ofNullable(request.getJsonPayload()).map(json -> (CredentialsObject)json.mapTo(CredentialsObject.class)).orElse(null);
        if (tenantId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, "missing tenant ID"));
        }
        if (payload == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, "missing payload"));
        }
        try {
            payload.checkValidity(this::checkSecret);
            Future result = Future.future();
            this.update(tenantId, JsonObject.mapFrom((Object)payload), (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result.completer());
            return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(payload.getDeviceId()).setCacheDirective(res.getCacheDirective()));
        }
        catch (IllegalStateException e) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, e.getMessage()));
        }
    }

    private Future<EventBusMessage> processRemoveRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        JsonObject payload = request.getJsonPayload();
        if (tenantId == null || payload == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        String type = CompleteBaseCredentialsService.getTypesafeValueForField(String.class, payload, "type");
        String authId = CompleteBaseCredentialsService.getTypesafeValueForField(String.class, payload, "auth-id");
        String deviceId = CompleteBaseCredentialsService.getTypesafeValueForField(String.class, payload, "device-id");
        if (type == null) {
            this.log.debug("remove credentials request does not contain mandatory type parameter");
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (!type.equals("*") && authId != null) {
            this.log.debug("removing specific credentials [tenant: {}, type: {}, auth-id: {}]", new Object[]{tenantId, type, authId});
            Future result = Future.future();
            this.remove(tenantId, type, authId, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result.completer());
            return result.map(res -> request.getResponse(res.getStatus()).setCacheDirective(res.getCacheDirective()));
        }
        if (deviceId != null && type.equals("*")) {
            this.log.debug("removing all credentials for device [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
            Future result = Future.future();
            this.removeAll(tenantId, deviceId, (Handler<AsyncResult<CredentialsResult<JsonObject>>>)result.completer());
            return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setCacheDirective(res.getCacheDirective()));
        }
        this.log.debug("remove credentials request contains invalid search criteria [type: {}, device-id: {}, auth-id: {}]", new Object[]{type, deviceId, authId});
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    @Override
    public void add(String tenantId, JsonObject otherKeys, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void update(String tenantId, JsonObject otherKeys, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void remove(String tenantId, String type, String authId, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void removeAll(String tenantId, String deviceId, Handler<AsyncResult<CredentialsResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }
}

