/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.command;

import java.util.Objects;
import org.eclipse.hono.service.auth.device.Device;
import org.eclipse.hono.util.CommandConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandSubscription {
    private static final Logger LOG = LoggerFactory.getLogger(CommandSubscription.class);
    private String endpoint;
    private String req;
    private String tenant;
    private String deviceId;
    private boolean isAuthenticated;

    private CommandSubscription(String topic) {
        Objects.requireNonNull(topic);
        String[] parts = topic.split("\\/");
        if (parts.length != 5 || !"#".equals(parts[4])) {
            throw new IllegalArgumentException("topic filter does not match pattern: control|c/+/+/req|q/#");
        }
        this.endpoint = parts[0];
        if (!CommandConstants.isCommandEndpoint((String)this.endpoint)) {
            throw new IllegalArgumentException("the endpoint needs to be 'control' or 'c'");
        }
        this.req = parts[3];
        if (!"req".equals(this.req) && !"q".equals(this.req)) {
            throw new IllegalArgumentException("the request part needs to be 'req' or 'q'");
        }
        if (!"+".equals(parts[1])) {
            this.tenant = parts[1];
        }
        if (!"+".equals(parts[2])) {
            this.deviceId = parts[2];
        }
    }

    private CommandSubscription(String topic, Device authenticatedDevice) {
        this(topic);
        if (authenticatedDevice == null) {
            this.isAuthenticated = false;
            if (this.tenant == null || this.tenant.isEmpty()) {
                throw new IllegalArgumentException("for unauthenticated devices the tenant needs to be given in the subscription");
            }
            if (this.deviceId == null || this.deviceId.isEmpty()) {
                throw new IllegalArgumentException("for unauthenticated devices the device-id needs to be given in the subscription");
            }
        } else {
            this.isAuthenticated = true;
            if (this.tenant != null && !authenticatedDevice.getTenantId().equals(this.tenant) || this.deviceId != null && !authenticatedDevice.getDeviceId().equals(this.deviceId)) {
                throw new IllegalArgumentException("for authenticated devices the given device-id and tenant need to match the authentication or be undefined ('+')");
            }
            this.tenant = authenticatedDevice.getTenantId();
            this.deviceId = authenticatedDevice.getDeviceId();
        }
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getRequestPart() {
        return this.req;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public static CommandSubscription fromTopic(String topic, Device authenticatedDevice) {
        try {
            return new CommandSubscription(topic, authenticatedDevice);
        }
        catch (IllegalArgumentException e) {
            LOG.debug(e.getMessage());
            return null;
        }
    }
}

