/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.command;

import io.opentracing.Span;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonReceiver;
import java.util.HashMap;
import java.util.Objects;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.eclipse.hono.service.command.Command;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.MapBasedExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommandContext
extends MapBasedExecutionContext {
    public static final String KEY_COMMAND_CONTEXT = "command-context";
    private static final Logger LOG = LoggerFactory.getLogger(CommandContext.class);
    private final Command command;
    private final ProtonDelivery delivery;
    private final ProtonReceiver receiver;
    private final Span currentSpan;

    private CommandContext(Command command, ProtonDelivery delivery, ProtonReceiver receiver, Span currentSpan) {
        this.command = command;
        this.delivery = delivery;
        this.receiver = receiver;
        this.currentSpan = currentSpan;
    }

    public static CommandContext from(Command command, ProtonDelivery delivery, ProtonReceiver receiver, Span currentSpan) {
        Objects.requireNonNull(command);
        Objects.requireNonNull(delivery);
        Objects.requireNonNull(receiver);
        Objects.requireNonNull(currentSpan);
        return new CommandContext(command, delivery, receiver, currentSpan);
    }

    public Command getCommand() {
        return this.command;
    }

    public Span getCurrentSpan() {
        return this.currentSpan;
    }

    public void accept() {
        LOG.trace("accepting command message [{}]", (Object)this.getCommand());
        ProtonHelper.accepted((ProtonDelivery)this.delivery, (boolean)true);
        this.currentSpan.log("accepted command for delivery to device");
    }

    public void release() {
        ProtonHelper.released((ProtonDelivery)this.delivery, (boolean)true);
        TracingHelper.logError((Span)this.currentSpan, (String)"cannot process command");
    }

    public void reject(ErrorCondition errorCondition) {
        Rejected rejected = new Rejected();
        HashMap<String, String> items = new HashMap<String, String>(2);
        items.put("event", "cannot process command");
        if (errorCondition != null) {
            items.put("message", errorCondition.getDescription());
            rejected.setError(errorCondition);
        }
        this.delivery.disposition((DeliveryState)rejected, true);
        TracingHelper.logError((Span)this.currentSpan, items);
    }

    public void flow(int credits) {
        if (credits < 1) {
            throw new IllegalArgumentException("credits must be positve");
        }
        this.currentSpan.log(String.format("flowing %d credits to sender", credits));
        this.receiver.flow(credits);
    }
}

