/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.command;

import io.vertx.core.buffer.Buffer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.ResourceIdentifier;

public final class Command {
    private final boolean valid;
    private final Message message;
    private final String tenantId;
    private final String deviceId;
    private final String correlationId;
    private final String replyToId;
    private final String requestId;

    private Command(boolean valid, Message message, String tenantId, String deviceId, String correlationId, String replyToId) {
        this.valid = valid;
        this.message = message;
        this.tenantId = tenantId;
        this.deviceId = deviceId;
        this.correlationId = correlationId;
        this.replyToId = replyToId;
        this.requestId = Command.getRequestId(correlationId, replyToId, deviceId);
    }

    public static Command from(Message message, String tenantId, String deviceId) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        boolean valid = message.getSubject() != null;
        String correlationId = Optional.ofNullable(message.getCorrelationId()).map(obj -> {
            if (obj instanceof String) {
                return (String)obj;
            }
            return null;
        }).orElseGet(() -> {
            Object obj = message.getMessageId();
            if (obj instanceof String) {
                return (String)obj;
            }
            return null;
        });
        if (correlationId == null) {
            valid = false;
        }
        String replyToId = null;
        if (message.getReplyTo() == null) {
            valid = false;
        } else {
            try {
                ResourceIdentifier replyTo = ResourceIdentifier.fromString((String)message.getReplyTo());
                if (!"control".equals(replyTo.getEndpoint())) {
                    valid = false;
                } else if (!tenantId.equals(replyTo.getTenantId())) {
                    valid = false;
                } else {
                    replyToId = replyTo.getPathWithoutBase();
                    if (replyToId == null) {
                        valid = false;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                valid = false;
            }
        }
        Command result = new Command(valid, message, tenantId, deviceId, correlationId, replyToId);
        return result;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getName() {
        if (this.isValid()) {
            return this.message.getSubject();
        }
        throw new IllegalStateException("command is invalid");
    }

    public String getTenant() {
        if (this.isValid()) {
            return this.tenantId;
        }
        throw new IllegalStateException("command is invalid");
    }

    public String getDeviceId() {
        if (this.isValid()) {
            return this.deviceId;
        }
        throw new IllegalStateException("command is invalid");
    }

    public String getRequestId() {
        if (this.isValid()) {
            return this.requestId;
        }
        throw new IllegalStateException("command is invalid");
    }

    public Buffer getPayload() {
        if (this.isValid()) {
            return MessageHelper.getPayload((Message)this.message);
        }
        throw new IllegalStateException("command is invalid");
    }

    public String getContentType() {
        if (this.isValid()) {
            return this.message.getContentType();
        }
        throw new IllegalStateException("command is invalid");
    }

    public String getReplyToId() {
        if (this.isValid()) {
            return this.replyToId;
        }
        throw new IllegalStateException("command is invalid");
    }

    public String getCorrelationId() {
        if (this.isValid()) {
            return this.correlationId;
        }
        throw new IllegalStateException("command is invalid");
    }

    public Map<String, Object> getApplicationProperties() {
        if (this.isValid()) {
            if (this.message.getApplicationProperties() == null) {
                return null;
            }
            return this.message.getApplicationProperties().getValue();
        }
        throw new IllegalStateException("command is invalid");
    }

    public static String getRequestId(String correlationId, String replyToId, String deviceId) {
        if (correlationId == null || replyToId == null || deviceId == null) {
            return null;
        }
        String stringOne = Optional.ofNullable(correlationId).orElse("");
        String stringTwo = Optional.ofNullable(replyToId).orElse("");
        boolean removeDeviceFromReplyTo = stringTwo.startsWith(deviceId + "/");
        if (removeDeviceFromReplyTo) {
            stringTwo = stringTwo.substring(deviceId.length() + 1);
        }
        return String.format("%s%02x%s%s", removeDeviceFromReplyTo ? "1" : "0", stringOne.length(), stringOne, stringTwo);
    }

    public String toString() {
        if (this.valid) {
            return String.format("Command [name: %s, tenant-id: %s, device-id %s, request-id: %s]", this.getName(), this.getTenant(), this.getDeviceId(), this.getRequestId());
        }
        return "Invalid Command";
    }
}

