/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.impl.HttpStatusException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.hono.service.auth.device.HonoAuthHandler;

public class HonoChainAuthHandler
extends HonoAuthHandler
implements ChainAuthHandler {
    private final List<AuthHandler> handlers = new ArrayList<AuthHandler>();

    public HonoChainAuthHandler() {
        super(null);
    }

    public ChainAuthHandler append(AuthHandler other) {
        this.handlers.add(other);
        return this;
    }

    public boolean remove(AuthHandler other) {
        return this.handlers.remove(other);
    }

    public void clear() {
        this.handlers.clear();
    }

    @Override
    public AuthHandler addAuthority(String authority) {
        for (AuthHandler h : this.handlers) {
            h.addAuthority(authority);
        }
        return this;
    }

    @Override
    public AuthHandler addAuthorities(Set<String> authorities) {
        for (AuthHandler h : this.handlers) {
            h.addAuthorities(authorities);
        }
        return this;
    }

    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        this.iterate(0, context, null, handler);
    }

    private void iterate(int idx, RoutingContext ctx, HttpStatusException lastException, Handler<AsyncResult<JsonObject>> handler) {
        if (idx >= this.handlers.size()) {
            handler.handle((Object)Future.failedFuture((Throwable)lastException));
            return;
        }
        AuthHandler authHandler = this.handlers.get(idx);
        authHandler.parseCredentials(ctx, res -> {
            if (res.failed()) {
                if (res.cause() instanceof HttpStatusException) {
                    HttpStatusException exception = (HttpStatusException)res.cause();
                    switch (exception.getStatusCode()) {
                        case 302: 
                        case 400: 
                        case 401: 
                        case 403: {
                            this.iterate(idx + 1, ctx, exception, handler);
                            return;
                        }
                    }
                }
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                return;
            }
            if (authHandler instanceof HonoAuthHandler) {
                ctx.put("io.vertx.ext.web.handler.AuthHandler.provider", (Object)((HonoAuthHandler)authHandler).authProvider);
            }
            handler.handle((Object)Future.succeededFuture((Object)res.result()));
        });
    }
}

