/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.vertx.core.Future;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.service.auth.AuthenticationService;
import org.eclipse.hono.util.AuthenticationConstants;
import org.eclipse.hono.util.ConfigurationSupportingVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAuthenticationService<T>
extends ConfigurationSupportingVerticle<T>
implements AuthenticationService {
    private static final Logger LOG = LoggerFactory.getLogger(BaseAuthenticationService.class);
    private MessageConsumer<JsonObject> authRequestConsumer;

    public final void start(Future<Void> startFuture) {
        this.authRequestConsumer = this.vertx.eventBus().consumer("authentication.in", this::processMessage);
        LOG.info("listening on event bus [address: {}] for authentication requests", (Object)"authentication.in");
        this.doStart(startFuture);
    }

    protected void doStart(Future<Void> startFuture) {
        startFuture.complete();
    }

    public final void stop(Future<Void> stopFuture) {
        LOG.info("unregistering event bus listener [address: {}]", (Object)"authentication.in");
        this.authRequestConsumer.unregister();
        this.doStop(stopFuture);
    }

    protected void doStop(Future<Void> stopFuture) {
        stopFuture.complete();
    }

    private void processMessage(Message<JsonObject> message) {
        JsonObject body = (JsonObject)message.body();
        this.authenticate(body, validation -> {
            if (validation.succeeded()) {
                message.reply((Object)AuthenticationConstants.getAuthenticationReply((String)((HonoUser)validation.result()).getToken()));
            } else {
                message.fail(10, validation.cause().getMessage());
            }
        });
    }
}

