/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.metric;

import java.util.Objects;
import org.eclipse.hono.service.metric.MetricConfig;
import org.eclipse.hono.service.metric.Metrics;
import org.eclipse.hono.service.metric.NullCounterService;
import org.eclipse.hono.service.metric.NullGaugeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;

public abstract class DropwizardBasedMetrics
implements Metrics {
    protected static final String METER_PREFIX = "meter";
    protected static final String TIMER_PREFIX = "timer";
    protected static final String HISTOGRAM_PREFIX = "histogram";
    protected static final String MESSAGES = "messages";
    protected static final String PROCESSED = "processed";
    protected static final String DISCARDED = "discarded";
    protected static final String UNDELIVERABLE = "undeliverable";
    protected static final String CONNECTIONS = "connections";
    protected static final String COMMANDS = "commands";
    protected static final String PAYLOAD = "payload";
    protected GaugeService gaugeService = NullGaugeService.getInstance();
    protected CounterService counterService = NullCounterService.getInstance();

    @Autowired(required=false)
    public final void setMetricConfig(MetricConfig metricConfig) {
        metricConfig.setPrefix(this.getScope());
    }

    protected abstract String getScope();

    @Autowired(required=false)
    public final void setGaugeService(GaugeService gaugeService) {
        this.gaugeService = gaugeService;
    }

    @Autowired(required=false)
    public final void setCounterService(CounterService counterService) {
        this.counterService = counterService;
    }

    protected static final String normalizeAddress(String address) {
        Objects.requireNonNull(address);
        return address.replace('/', '.');
    }

    protected static final String mergeAsMetric(String ... parts) {
        return String.join((CharSequence)".", parts);
    }

    @Override
    public final void incrementConnections(String tenantId) {
        this.counterService.increment(DropwizardBasedMetrics.mergeAsMetric(this.getScope(), CONNECTIONS, "authenticated", tenantId));
    }

    @Override
    public final void decrementConnections(String tenantId) {
        this.counterService.decrement(DropwizardBasedMetrics.mergeAsMetric(this.getScope(), CONNECTIONS, "authenticated", tenantId));
    }

    @Override
    public final void incrementUnauthenticatedConnections() {
        this.counterService.increment(DropwizardBasedMetrics.mergeAsMetric(this.getScope(), CONNECTIONS, "unauthenticated"));
    }

    @Override
    public final void decrementUnauthenticatedConnections() {
        this.counterService.decrement(DropwizardBasedMetrics.mergeAsMetric(this.getScope(), CONNECTIONS, "unauthenticated"));
    }

    @Override
    public final void incrementProcessedMessages(String resourceId, String tenantId) {
        this.counterService.increment(DropwizardBasedMetrics.mergeAsMetric(METER_PREFIX, this.getScope(), MESSAGES, resourceId, tenantId, PROCESSED));
    }

    @Override
    public final void incrementUndeliverableMessages(String resourceId, String tenantId) {
        this.counterService.increment(DropwizardBasedMetrics.mergeAsMetric(this.getScope(), MESSAGES, resourceId, tenantId, UNDELIVERABLE));
    }

    @Override
    public final void incrementProcessedPayload(String resourceId, String tenantId, long payloadSize) {
        if (payloadSize < 0L) {
            return;
        }
        this.counterService.increment(DropwizardBasedMetrics.mergeAsMetric(METER_PREFIX, this.getScope(), PAYLOAD, resourceId, tenantId, PROCESSED));
    }

    @Override
    public final void incrementCommandDeliveredToDevice(String tenantId) {
        this.counterService.increment(DropwizardBasedMetrics.mergeAsMetric(METER_PREFIX, this.getScope(), COMMANDS, tenantId, "device", "delivered"));
    }

    @Override
    public final void incrementNoCommandReceivedAndTTDExpired(String tenantId) {
        this.counterService.increment(DropwizardBasedMetrics.mergeAsMetric(METER_PREFIX, this.getScope(), COMMANDS, tenantId, "ttd", "expired"));
    }

    @Override
    public final void incrementCommandResponseDeliveredToApplication(String tenantId) {
        this.counterService.increment(DropwizardBasedMetrics.mergeAsMetric(METER_PREFIX, this.getScope(), COMMANDS, tenantId, "response", "delivered"));
    }
}

