/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.command;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonQoS;
import io.vertx.proton.ProtonReceiver;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.hono.client.MessageConsumer;
import org.eclipse.hono.client.impl.AbstractConsumer;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.service.command.Command;
import org.eclipse.hono.service.command.CommandContext;
import org.eclipse.hono.tracing.MessageAnnotationsExtractAdapter;
import org.eclipse.hono.util.ResourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandConsumer
extends AbstractConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(CommandConsumer.class);

    private CommandConsumer(Context context, ClientConfigProperties config, ProtonReceiver protonReceiver, Tracer tracer) {
        super(context, config, protonReceiver, tracer);
    }

    public static final void create(Context context, ClientConfigProperties clientConfig, ProtonConnection con, String tenantId, String deviceId, Handler<CommandContext> commandHandler, Handler<String> receiverCloseHook, Handler<AsyncResult<MessageConsumer>> creationHandler, Tracer tracer) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(clientConfig);
        Objects.requireNonNull(con);
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(commandHandler);
        Objects.requireNonNull(receiverCloseHook);
        Objects.requireNonNull(creationHandler);
        LOG.trace("creating new command consumer [tenant-id: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
        String address = ResourceIdentifier.from((String)"control", (String)tenantId, (String)deviceId).toString();
        ClientConfigProperties props = new ClientConfigProperties(clientConfig);
        props.setInitialCredits(0);
        AtomicReference receiverRef = new AtomicReference();
        CommandConsumer.createReceiver((Context)context, (ClientConfigProperties)props, (ProtonConnection)con, (String)address, (ProtonQoS)ProtonQoS.AT_LEAST_ONCE, (delivery, msg) -> {
            Command command = Command.from(msg, tenantId, deviceId);
            SpanContext spanContext = tracer.extract(Format.Builtin.TEXT_MAP, (Object)new MessageAnnotationsExtractAdapter(msg));
            Span currentSpan = tracer.buildSpan("send command").addReference("child_of", spanContext).ignoreActiveSpan().withTag(Tags.COMPONENT.getKey(), CommandConsumer.class.getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "consumer").withTag("tenant_id", tenantId).withTag("device_id", deviceId).start();
            HashMap<String, String> items = new HashMap<String, String>(3);
            items.put("event", "received command message");
            if (command.isValid()) {
                currentSpan.setTag("hono-cmd-req-id", command.getRequestId());
                items.put("name", command.getName());
                items.put("content-type", command.getContentType());
            }
            currentSpan.log(items);
            try {
                commandHandler.handle((Object)CommandContext.from(command, delivery, (ProtonReceiver)receiverRef.get(), currentSpan));
            }
            finally {
                currentSpan.finish();
            }
        }, receiverCloseHook).setHandler(s -> {
            if (s.succeeded()) {
                ProtonReceiver receiver = (ProtonReceiver)s.result();
                LOG.debug("successfully created command consumer [tenant-id: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
                receiverRef.set(receiver);
                receiver.flow(1);
                creationHandler.handle((Object)Future.succeededFuture((Object)((Object)new CommandConsumer(context, props, receiver, tracer))));
            } else {
                LOG.debug("failed to create command consumer [tenant-id: {}, device-id: {}]", new Object[]{tenantId, deviceId, s.cause()});
                creationHandler.handle((Object)Future.failedFuture((Throwable)s.cause()));
            }
        });
    }
}

