/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.command;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.MessageConsumer;
import org.eclipse.hono.client.impl.HonoClientImpl;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.service.auth.device.Device;
import org.eclipse.hono.service.command.CommandConnection;
import org.eclipse.hono.service.command.CommandConsumer;
import org.eclipse.hono.service.command.CommandContext;
import org.eclipse.hono.service.command.CommandResponseSender;
import org.eclipse.hono.service.command.CommandResponseSenderImpl;

public class CommandConnectionImpl
extends HonoClientImpl
implements CommandConnection {
    private final Map<String, MessageConsumer> commandReceivers = new HashMap<String, MessageConsumer>();

    public CommandConnectionImpl(Vertx vertx, ClientConfigProperties clientConfigProperties) {
        super(vertx, clientConfigProperties);
    }

    protected void clearState() {
        super.clearState();
        this.commandReceivers.clear();
    }

    @Override
    public final Future<MessageConsumer> getOrCreateCommandConsumer(String tenantId, String deviceId, Handler<CommandContext> commandConsumer, Handler<Void> closeHandler) {
        MessageConsumer messageConsumer = this.commandReceivers.get(Device.asAddress(tenantId, deviceId));
        if (messageConsumer != null) {
            return Future.succeededFuture((Object)messageConsumer);
        }
        return this.createConsumer(tenantId, () -> this.newCommandConsumer(tenantId, deviceId, commandConsumer, closeHandler));
    }

    private Future<MessageConsumer> newCommandConsumer(String tenantId, String deviceId, Handler<CommandContext> commandConsumer, Handler<Void> closeHandler) {
        return this.checkConnected().compose(con -> {
            Future result = Future.future();
            CommandConsumer.create(this.context, this.clientConfigProperties, this.connection, tenantId, deviceId, commandConsumer, (Handler<String>)((Handler)closeHook -> this.closeCommandConsumer(tenantId, deviceId)), (Handler<AsyncResult<MessageConsumer>>)((Handler)creation -> {
                if (creation.succeeded()) {
                    this.commandReceivers.put(Device.asAddress(tenantId, deviceId), (MessageConsumer)creation.result());
                }
                result.complete(creation.result());
            }), this.getTracer());
            return result;
        });
    }

    @Override
    public Future<Void> closeCommandConsumer(String tenantId, String deviceId) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Future result = Future.future();
        String deviceAddress = Device.asAddress(tenantId, deviceId);
        Optional.ofNullable(this.commandReceivers.remove(deviceAddress)).map(commandReceiverLink -> {
            commandReceiverLink.close((Handler)result);
            return commandReceiverLink;
        });
        return result;
    }

    @Override
    public Future<CommandResponseSender> getCommandResponseSender(String tenantId, String replyId) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(replyId);
        return this.checkConnected().compose(connected -> {
            Future result = Future.future();
            CommandResponseSenderImpl.create(this.context, this.clientConfigProperties, this.connection, tenantId, replyId, (Handler<String>)((Handler)onSenderClosed -> {}), (Handler<AsyncResult<CommandResponseSender>>)result.completer(), this.getTracer());
            return result;
        });
    }
}

