/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.cache;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.hono.cache.BasicExpiringValue;
import org.eclipse.hono.cache.ExpiringValue;
import org.eclipse.hono.cache.ExpiringValueCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;

public class SpringBasedExpiringValueCache<K, V>
implements ExpiringValueCache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBasedExpiringValueCache.class);
    private final Cache cache;

    public SpringBasedExpiringValueCache(Cache cache) {
        this.cache = Objects.requireNonNull(cache);
    }

    public void put(K key, V value, Instant expirationTime) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Objects.requireNonNull(expirationTime);
        if (!Instant.now().isBefore(expirationTime)) {
            throw new IllegalArgumentException("value is already expired");
        }
        BasicExpiringValue expiringValue = new BasicExpiringValue(value, expirationTime);
        this.cache.put(key, (Object)expiringValue);
    }

    public void put(K key, V value, Duration maxAge) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Objects.requireNonNull(maxAge);
        this.put(key, value, Instant.now().plus(maxAge));
    }

    public V get(K key) {
        if (key == null) {
            return null;
        }
        ExpiringValue value = (ExpiringValue)this.cache.get(key, ExpiringValue.class);
        if (value == null) {
            LOG.trace("cache miss [key: {}]", key);
            return null;
        }
        if (value.isExpired()) {
            LOG.trace("cache hit expired [key: {}]", key);
            this.cache.evict(key);
            return null;
        }
        LOG.trace("cache hit [key: {}]", key);
        return (V)value.getValue();
    }
}

