/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.auth.device.CredentialsApiAuthProvider;
import org.eclipse.hono.service.auth.device.DeviceCredentials;
import org.eclipse.hono.service.auth.device.SubjectDnCredentials;
import org.springframework.beans.factory.annotation.Autowired;

public class X509AuthProvider
extends CredentialsApiAuthProvider {
    private final ServiceConfigProperties config;

    @Autowired
    public X509AuthProvider(HonoClient credentialsServiceClient, ServiceConfigProperties config) {
        super(credentialsServiceClient);
        this.config = Objects.requireNonNull(config);
    }

    @Override
    protected DeviceCredentials getCredentials(JsonObject authInfo) {
        Objects.requireNonNull(authInfo);
        try {
            String tenantId = Optional.ofNullable(authInfo.getString("tenant-id")).orElseGet(() -> {
                if (this.config.isSingleTenant()) {
                    return "DEFAULT_TENANT";
                }
                return null;
            });
            String subjectDn = authInfo.getString("subject-dn");
            if (tenantId == null || subjectDn == null) {
                return null;
            }
            return SubjectDnCredentials.create(tenantId, subjectDn);
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

