/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.auth.device.CredentialsApiAuthProvider;
import org.eclipse.hono.service.auth.device.DeviceCredentials;
import org.eclipse.hono.service.auth.device.UsernamePasswordCredentials;
import org.springframework.beans.factory.annotation.Autowired;

public final class UsernamePasswordAuthProvider
extends CredentialsApiAuthProvider {
    private final ServiceConfigProperties config;

    @Autowired
    public UsernamePasswordAuthProvider(HonoClient credentialsServiceClient, ServiceConfigProperties config) {
        super(credentialsServiceClient);
        this.config = Objects.requireNonNull(config);
    }

    @Override
    protected DeviceCredentials getCredentials(JsonObject authInfo) {
        try {
            String username = authInfo.getString("username");
            String password = authInfo.getString("password");
            if (username == null || password == null) {
                return null;
            }
            return UsernamePasswordCredentials.create(username, password, this.config.isSingleTenant());
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

