/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.RequiredTypeException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Device
implements User {
    private final JsonObject principal;
    private final Set<Object> authorities = new HashSet<Object>();

    public Device(Jws<Claims> token) {
        this((String)((Claims)Objects.requireNonNull(token).getBody()).get("ten", String.class), ((Claims)token.getBody()).getSubject());
        try {
            Set aut = (Set)((Claims)token.getBody()).get("aut", Set.class);
            if (aut != null) {
                this.authorities.addAll(aut);
            }
        }
        catch (RequiredTypeException requiredTypeException) {
            // empty catch block
        }
    }

    public Device(String tenantId, String deviceId) {
        this.principal = this.getPrincipal(tenantId, deviceId);
    }

    private JsonObject getPrincipal(String tenantId, String deviceId) {
        return new JsonObject().put("tenant-id", Objects.requireNonNull(tenantId)).put("device-id", Objects.requireNonNull(deviceId));
    }

    public User isAuthorized(String authority, Handler<AsyncResult<Boolean>> resultHandler) {
        for (Object item : this.authorities) {
            if (!authority.equals(item)) continue;
            resultHandler.handle((Object)Future.succeededFuture((Object)Boolean.TRUE));
            return this;
        }
        resultHandler.handle((Object)Future.succeededFuture((Object)Boolean.FALSE));
        return this;
    }

    public JsonObject principal() {
        return this.principal;
    }

    public void setAuthProvider(AuthProvider authProvider) {
    }

    public User clearCache() {
        return this;
    }

    public String getTenantId() {
        return this.principal.getString("tenant-id");
    }

    public String getDeviceId() {
        return this.principal.getString("device-id");
    }

    public String toString() {
        return String.format("device [%s: %s, %s: %s]", "device-id", this.getDeviceId(), "tenant-id", this.getTenantId());
    }

    public static String asAddress(String tenantId, String deviceId) {
        return String.format("%s/%s", tenantId, deviceId);
    }

    public static String asAddress(Device device) {
        return String.format("%s/%s", device.getTenantId(), device.getDeviceId());
    }
}

