/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.service.auth.device.DeviceCredentials;
import org.eclipse.hono.util.CredentialsObject;

public abstract class AbstractDeviceCredentials
implements DeviceCredentials {
    private final String tenantId;
    private final String authId;

    protected AbstractDeviceCredentials(String tenantId, String authId) {
        this.tenantId = tenantId;
        this.authId = authId;
    }

    @Override
    public final String getAuthId() {
        return this.authId;
    }

    @Override
    public final String getTenantId() {
        return this.tenantId;
    }

    @Override
    public final boolean validate(CredentialsObject credentialsOnRecord) {
        Objects.requireNonNull(credentialsOnRecord);
        if (!this.getAuthId().equals(credentialsOnRecord.getAuthId())) {
            return false;
        }
        if (!this.getType().equals(credentialsOnRecord.getType())) {
            return false;
        }
        if (!credentialsOnRecord.isEnabled()) {
            return false;
        }
        return credentialsOnRecord.getCandidateSecrets().stream().anyMatch(candidateSecret -> this.matchesCredentials((JsonObject)candidateSecret));
    }

    public abstract boolean matchesCredentials(JsonObject var1);
}

