/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import java.util.Objects;
import org.eclipse.hono.service.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEndpoint
implements Endpoint {
    protected final Vertx vertx;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected AbstractEndpoint(Vertx vertx) {
        this.vertx = Objects.requireNonNull(vertx);
    }

    @Override
    public final Future<Void> start() {
        Future result = Future.future();
        if (this.vertx == null) {
            result.fail((Throwable)new IllegalStateException("Vert.x instance must be set"));
        } else {
            this.doStart((Future<Void>)result);
        }
        return result;
    }

    protected void doStart(Future<Void> startFuture) {
        startFuture.complete();
    }

    @Override
    public final Future<Void> stop() {
        Future result = Future.future();
        this.doStop((Future<Void>)result);
        return result;
    }

    protected void doStop(Future<Void> stopFuture) {
        stopFuture.complete();
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler handler) {
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler handler) {
    }
}

