/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tenant;

import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.util.BaseMessageFilter;
import org.eclipse.hono.util.ResourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TenantMessageFilter
extends BaseMessageFilter {
    private static final Logger LOG = LoggerFactory.getLogger(TenantMessageFilter.class);

    private TenantMessageFilter() {
    }

    public static boolean verify(ResourceIdentifier linkTarget, Message msg) {
        if (msg.getMessageId() == null && msg.getCorrelationId() == null) {
            LOG.trace("message has neither a message-id nor correlation-id");
            return false;
        }
        if (msg.getSubject() == null) {
            LOG.trace("message [{}] does not contain subject", msg.getMessageId());
            return false;
        }
        if (msg.getReplyTo() == null) {
            LOG.trace("message [{}] contains no reply-to address", msg.getMessageId());
            return false;
        }
        if (msg.getBody() != null) {
            if (!(msg.getBody() instanceof AmqpValue)) {
                LOG.trace("message [{}] contains non-AmqpValue section payload", msg.getMessageId());
                return false;
            }
            return true;
        }
        return true;
    }
}

